/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.core.query.AbstractAtsConfigQueryImpl;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class AtsConfigQueryImpl
extends AbstractAtsConfigQueryImpl {
    private QueryBuilderArtifact query;

    public AtsConfigQueryImpl(AtsApi atsApi) {
        super(atsApi);
    }

    public Collection<ArtifactToken> runQuery() {
        ArrayList<ArtifactToken> results = new ArrayList<ArtifactToken>();
        Iterator iterator = this.query.getResults().iterator();
        while (iterator.hasNext()) {
            results.add((ArtifactToken)iterator.next());
        }
        return results;
    }

    public void createQueryBuilder() {
        this.query = ArtifactQuery.createQueryBuilder((BranchId)AtsApiService.get().getAtsBranch());
    }

    private QueryBuilderArtifact getQuery() {
        Conditions.checkNotNull((Object)this.query, (String)"Query builder not created");
        return this.query;
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values) {
        this.getQuery().and(attrType, values, new QueryOption[0]);
    }

    public void queryAndIsOfType(ArtifactTypeToken artifactType) {
        this.getQuery().andIsOfType(new ArtifactTypeId[]{artifactType});
    }

    public List<ArtifactId> queryGetIds() {
        return this.getQuery().getIds();
    }

    public void queryAndIsOfType(List<ArtifactTypeToken> artTypes) {
        this.getQuery().andIsOfType(artTypes);
    }

    public void queryAnd(AttributeTypeId attrType, String value) {
        this.getQuery().and(attrType, value, new QueryOption[0]);
    }

    public void queryAnd(AttributeTypeId attrType, Collection<String> values, QueryOption[] queryOption) {
        this.getQuery().and(attrType, values, queryOption);
    }

    public void queryAnd(AttributeTypeId attrType, String value, QueryOption[] queryOption) {
        this.getQuery().and(attrType, value, queryOption);
    }

    public void queryAndArtifactId(ArtifactId artifactId) {
        this.getQuery().andId(artifactId);
    }

    public void queryAndNotExists(RelationTypeSide relationTypeSide) {
        this.getQuery().andNotExists(relationTypeSide);
    }

    public void queryAndExists(RelationTypeSide relationTypeSide) {
        this.getQuery().andExists(relationTypeSide);
    }
}

