/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.agile.AgileUtil;
import org.eclipse.osee.ats.ide.actions.NewGoal;
import org.eclipse.osee.ats.ide.actions.OpenArtifactEditorById;
import org.eclipse.osee.ats.ide.actions.OpenOrphanedTasks;
import org.eclipse.osee.ats.ide.actions.OpenWorkflowByIdAction;
import org.eclipse.osee.ats.ide.actions.RevertDuplicateAtsTransitionByIdAction;
import org.eclipse.osee.ats.ide.actions.RevertDuplicateAtsTransitionsAction;
import org.eclipse.osee.ats.ide.actions.ValidatePeerDefectsAction;
import org.eclipse.osee.ats.ide.branch.CreateAtsBaselineBranchBlam;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigResultsEditorNavigateItem;
import org.eclipse.osee.ats.ide.config.version.CreateNewVersionItem;
import org.eclipse.osee.ats.ide.config.version.GenerateFullVersionReportItem;
import org.eclipse.osee.ats.ide.config.version.GenerateVersionReportItem;
import org.eclipse.osee.ats.ide.config.version.MassEditTeamVersionItem;
import org.eclipse.osee.ats.ide.config.version.ParallelConfigurationView;
import org.eclipse.osee.ats.ide.config.version.ReleaseVersionItem;
import org.eclipse.osee.ats.ide.ev.OpenWorkPackageByIdAction;
import org.eclipse.osee.ats.ide.ev.WorkPackageConfigReport;
import org.eclipse.osee.ats.ide.ev.WorkPackageQBDReport;
import org.eclipse.osee.ats.ide.export.AtsExportAction;
import org.eclipse.osee.ats.ide.health.AtsHealthCheckNavigateItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.ArtifactImpactToActionSearchItem;
import org.eclipse.osee.ats.ide.navigate.ClearAtsConfigCache;
import org.eclipse.osee.ats.ide.navigate.CommaDelimitLines;
import org.eclipse.osee.ats.ide.navigate.CompareEditorExample;
import org.eclipse.osee.ats.ide.navigate.CreateNewUsersByNameItem;
import org.eclipse.osee.ats.ide.navigate.DisplayCurrentOseeEventListeners;
import org.eclipse.osee.ats.ide.navigate.EmailTeamsItem;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeArtifactDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeDialogSelectAllExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeArtifactDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeDialogSingleExample;
import org.eclipse.osee.ats.ide.navigate.FirstTimeQualityMetricReportItem;
import org.eclipse.osee.ats.ide.navigate.GenerateIdsAndArtId;
import org.eclipse.osee.ats.ide.navigate.RecentlyVisitedNavigateItems;
import org.eclipse.osee.ats.ide.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.navigate.SubscribeByActionableItem;
import org.eclipse.osee.ats.ide.navigate.SubscribeByTeamDefinition;
import org.eclipse.osee.ats.ide.navigate.ToggleAccessControlDebug;
import org.eclipse.osee.ats.ide.navigate.ValidateOseeTypes;
import org.eclipse.osee.ats.ide.navigate.XResultDataTableExample;
import org.eclipse.osee.ats.ide.notify.EmailActionsBlam;
import org.eclipse.osee.ats.ide.operation.ConvertWorkflowStatesBlam;
import org.eclipse.osee.ats.ide.search.AtsQuickSearchOperationFactory;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.util.AtsEditor;
import org.eclipse.osee.ats.ide.util.CleanupOseeSystemAssignedWorkflows;
import org.eclipse.osee.ats.ide.workdef.ValidateWorkDefinitionNavigateItem;
import org.eclipse.osee.ats.ide.workdef.editor.WorkDefinitionViewer;
import org.eclipse.osee.ats.ide.workflow.review.GenerateReviewParticipationReport;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerToPeerReviewItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchGoalSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchReviewSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTaskSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTeamWorkflowSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchWorkPackageSearchItem;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchData;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchOperation;
import org.eclipse.osee.ats.ide.world.search.MyFavoritesSearchItem;
import org.eclipse.osee.ats.ide.world.search.MyReviewSearchItem;
import org.eclipse.osee.ats.ide.world.search.MySubscribedSearchItem;
import org.eclipse.osee.ats.ide.world.search.MyWorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.NextVersionSearchItem;
import org.eclipse.osee.ats.ide.world.search.SearchTeamWorkflowsByProgramSearchItem;
import org.eclipse.osee.ats.ide.world.search.ShowOpenWorkflowsByReviewType;
import org.eclipse.osee.ats.ide.world.search.UserRelatedToAtsObjectSearch;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IOperationFactory;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemFolder;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemOperation;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateUrlItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.action.CompareTwoArtifactIdListsAction;
import org.eclipse.osee.framework.ui.skynet.action.CompareTwoStringsAction;
import org.eclipse.osee.framework.ui.skynet.action.PurgeTransactionAction;
import org.eclipse.osee.framework.ui.skynet.action.XWidgetsDialogExampleAction;
import org.eclipse.osee.framework.ui.skynet.artifact.MassEditDirtyArtifactOperation;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.change.OpenChangeReportByTransactionIdAction;
import org.eclipse.osee.framework.ui.skynet.results.example.ResultsEditorExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XResultDataDialogExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XResultDataExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XViewerExample;
import org.eclipse.osee.framework.ui.skynet.user.OpenUsersInMassEditor;
import org.eclipse.osee.framework.ui.skynet.util.email.EmailUserGroups;
import org.eclipse.osee.framework.ui.skynet.widgets.xnavigate.XNavigateItemBlam;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public final class AtsNavigateViewItems
implements XNavigateItemProvider {
    public static final XNavItemCat GOALS = new XNavItemCat("Goals");
    public static final XNavItemCat ATS = new XNavItemCat("ATS");
    public static final XNavItemCat ATS_IMPORT = new XNavItemCat("ATS.Import");
    public static final XNavItemCat ATS_UTIL = new XNavItemCat("ATS.Utility");
    public static final XNavItemCat ATS_ADMIN = new XNavItemCat("ATS.Admin");
    public static final XNavItemCat ATS_HEALTH = new XNavItemCat("ATS.Health");
    public static final XNavItemCat ATS_VERSIONS = new XNavItemCat("ATS.Versions");
    public static final XNavItemCat ATS_VERSIONS_ADMIN = new XNavItemCat("ATS.Versions.Admin");
    public static final XNavItemCat ATS_WORK_DEFINITION = new XNavItemCat("ATS.Work Definition");
    public static final XNavItemCat ATS_WORK_DEFINITION_ADMIN = new XNavItemCat("ATS.Work Definition.Admin");
    public static final XNavItemCat ATS_EARNED_VALUE = new XNavItemCat("ATS.Earned Value");
    public static final XNavItemCat ATS_ADVANCED_SEARCHES = new XNavItemCat("Advanced Searches");
    public static final XNavItemCat REVIEW = new XNavItemCat("Review");
    public static boolean debug = false;
    private List<XNavigateItem> items;

    public boolean isApplicable() {
        return true;
    }

    public List<XNavigateItem> getNavigateItems(List<XNavigateItem> items) {
        this.items = items == null ? new ArrayList<XNavigateItem>() : items;
        ElapsedTime time = new ElapsedTime("NVI - addAtsSectionChildren", debug);
        try {
            this.addTopSearchItems();
            this.addAdvancedSearchesItems();
            this.addEmailItems();
            this.addReportItems();
            this.addTraceItems();
            this.addGoalItems();
            this.addDefineItems();
            this.addAtsItems();
            this.addUtilItems();
            this.addUserItems();
            this.addReviewItems();
            this.addEvNavigateItems();
            this.addAdminItems();
            this.addExampleItems();
            this.addOteItems();
            this.addPleItems();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
        return items;
    }

    private void addTopSearchItems() {
        ElapsedTime time2 = new ElapsedTime("NVI - addAtsSectionChildren - My World", debug);
        this.items.add(new SearchNavigateItem((WorldSearchItem)new MyWorldSearchItem("My World", true), XNavItemCat.TOP));
        time2.end();
        time2.start("NVI - addAtsSectionChildren - Recently Visited");
        this.items.add((XNavigateItem)new RecentlyVisitedNavigateItems(XNavItemCat.TOP));
        time2.end();
        time2.start("NVI - addAtsSectionChildren - Search");
        this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchWorkflowSearchItem(), XNavItemCat.TOP));
        time2.end();
        time2.start("NVI - addAtsSectionChildren - Saved Srch");
        this.items.add(new SavedActionSearchNavigateItem(XNavItemCat.TOP));
        time2.end();
    }

    private void addUserItems() {
        ElapsedTime time = new ElapsedTime("NVI - addUserItems", debug);
        List<IUserGroupArtifactToken> adminOrUserMgmt = Arrays.asList(CoreUserGroups.UserMgmtAdmin, CoreUserGroups.OseeAdmin);
        this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.USER_MANAGEMENT.getName(), (KeyedImage)FrameworkImage.USER, adminOrUserMgmt, new XNavItemCat[]{XNavItemCat.TOP}));
        this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (KeyedImage)FrameworkImage.USER, adminOrUserMgmt, new XNavItemCat[]{XNavigateItem.USER_MANAGEMENT_ADMIN, XNavItemCat.SUBCAT}));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenUsersInMassEditor("Open Active Users", Active.Active), (KeyedImage)FrameworkImage.ARTIFACT_SEARCH, adminOrUserMgmt, new XNavItemCat[]{XNavigateItem.USER_MANAGEMENT, XNavItemCat.OSEE_ADMIN}));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenUsersInMassEditor("Open All Users", Active.Both), (KeyedImage)FrameworkImage.ARTIFACT_SEARCH, adminOrUserMgmt, new XNavItemCat[]{XNavigateItem.USER_MANAGEMENT, XNavItemCat.OSEE_ADMIN}));
        this.items.add((XNavigateItem)new CreateNewUsersByNameItem());
        this.items.add(new SearchNavigateItem((WorldSearchItem)new UserRelatedToAtsObjectSearch("Admin - Show User Related Objects", null, false, WorldSearchItem.LoadView.WorldEditor), XNavigateItem.USER_MANAGEMENT_ADMIN, XNavItemCat.OSEE_ADMIN));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new UserRelatedToAtsObjectSearch("Show Active User Related Objects", null, true, WorldSearchItem.LoadView.WorldEditor), XNavigateItem.USER_MANAGEMENT_ADMIN, XNavItemCat.OSEE_ADMIN));
        time.end();
    }

    private void addDefineItems() {
        ElapsedTime time = new ElapsedTime("NVI - addDefineItems", debug);
        try {
            this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.DEFINE.getName(), (KeyedImage)FrameworkImage.LASER, new XNavItemCat[]{XNavItemCat.TOP}));
            this.items.add((XNavigateItem)new XNavigateItemFolder("Health", (KeyedImage)FrameworkImage.HEALTH, new XNavItemCat[]{XNavigateItem.DEFINE_HEALTH, XNavItemCat.SUBCAT}));
            this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (KeyedImage)FrameworkImage.LASER, new XNavItemCat[]{XNavigateItem.DEFINE_ADMIN, XNavItemCat.OSEE_ADMIN, XNavItemCat.SUBCAT}));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private void addOteItems() {
        ElapsedTime time = new ElapsedTime("NVI - addOteItems", debug);
        try {
            this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.OTE.getName(), (KeyedImage)FrameworkImage.TEST_PROCEDURE, new XNavItemCat[]{XNavItemCat.MID_BOT}));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private void addAtsItems() {
        ElapsedTime time = new ElapsedTime("NVI - addAtsItems", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder(ATS.getName(), (OseeImage)AtsImage.ATS, new XNavItemCat[]{XNavItemCat.TOP}));
        this.items.add((XNavigateItem)new XNavigateItemFolder("Utility", (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{ATS_UTIL, XNavItemCat.SUBCAT}));
        this.items.add((XNavigateItem)new XNavigateItemFolder("Import", (KeyedImage)FrameworkImage.IMPORT, new XNavItemCat[]{ATS_IMPORT, XNavItemCat.SUBCAT}));
        this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{ATS_ADMIN, XNavItemCat.SUBCAT, XNavItemCat.OSEE_ADMIN}));
        this.items.add((XNavigateItem)new AtsConfigResultsEditorNavigateItem());
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new AtsExportAction(), (KeyedImage)FrameworkImage.EXPORT, new XNavItemCat[]{ATS_UTIL}));
        this.items.add((XNavigateItem)new ClearAtsConfigCache());
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenOrphanedTasks(), (OseeImage)AtsImage.TASK, new XNavItemCat[]{ATS_ADMIN, XNavItemCat.OSEE_ADMIN}));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new RevertDuplicateAtsTransitionByIdAction(), (OseeImage)AtsImage.TASK, new XNavItemCat[]{ATS_ADMIN, XNavItemCat.OSEE_ADMIN}));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new RevertDuplicateAtsTransitionsAction(), (OseeImage)AtsImage.TASK, new XNavItemCat[]{ATS_ADMIN, XNavItemCat.OSEE_ADMIN}));
        this.addVersionsItems();
        this.addWorkDefinitionsItems();
        this.addHealthItems();
        time.end();
    }

    private void addHealthItems() {
        ElapsedTime time = new ElapsedTime("NVI - addAtsItems", debug);
        try {
            this.items.add((XNavigateItem)new XNavigateItemFolder("Health", (KeyedImage)FrameworkImage.HEALTH, new XNavItemCat[]{ATS_HEALTH, XNavItemCat.SUBCAT}));
            this.items.add(new AtsHealthCheckNavigateItem());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private void addUtilItems() {
        ElapsedTime time = new ElapsedTime("NVI - addUtilItems", debug);
        try {
            this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.UTILITY.getName(), (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{XNavItemCat.BOT}));
            this.items.add((XNavigateItem)new GenerateIdsAndArtId());
            this.items.add((XNavigateItem)new ValidateOseeTypes());
            this.items.add((XNavigateItem)new CommaDelimitLines());
            this.items.add((XNavigateItem)new ToggleAccessControlDebug());
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new CompareTwoStringsAction(), (KeyedImage)FrameworkImage.EDIT, new XNavItemCat[]{XNavigateItem.UTILITY}));
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new CompareTwoArtifactIdListsAction(), (KeyedImage)FrameworkImage.EDIT, new XNavItemCat[]{XNavigateItem.UTILITY}));
            this.items.add((XNavigateItem)new XNavigateItemOperation((KeyedImage)FrameworkImage.ARTIFACT_MASS_EDITOR, "Mass Edit Dirty Artifacts", (IOperationFactory)new MassEditDirtyArtifactOperation(), new XNavItemCat[]{XNavigateItem.UTILITY}));
            this.items.add((XNavigateItem)new XNavigateUrlItem("Disciplined Engineering and OSEE", "https://git.eclipse.org/c/gerrit/osee/org.eclipse.osee.git/plain/plugins/org.eclipse.osee.support.admin/presentations_publications/Disciplined_Engineering_with_OSEE.pptx", true, (KeyedImage)FrameworkImage.PPTX, XNavigateItem.UTILITY));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private void addAdvancedSearchesItems() {
        ElapsedTime time = new ElapsedTime("NVI - advSearch", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder(ATS_ADVANCED_SEARCHES.getName(), (OseeImage)AtsImage.SEARCH, new XNavItemCat[]{XNavItemCat.TOP}));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new MyFavoritesSearchItem("My Favorites", null), ATS_ADVANCED_SEARCHES));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new MySubscribedSearchItem("My Subscribed", null), ATS_ADVANCED_SEARCHES));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchTeamWorkflowSearchItem(), ATS_ADVANCED_SEARCHES));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchTaskSearchItem(), ATS_ADVANCED_SEARCHES));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new MyWorldSearchItem("User's World", false), ATS_ADVANCED_SEARCHES));
        this.items.add((XNavigateItem)new ArtifactImpactToActionSearchItem());
        this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchGoalSearchItem(), ATS_ADVANCED_SEARCHES));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new SearchTeamWorkflowsByProgramSearchItem("Search Team Workflows by Program", null, false), ATS_ADVANCED_SEARCHES));
        this.items.add((XNavigateItem)new XNavigateItemOperation((KeyedImage)FrameworkImage.BRANCH_CHANGE, "Open Change Report(s) by ID(s)", (IOperationFactory)new MultipleIdSearchOperationFactory("Open Change Report(s) by ID(s)", AtsEditor.ChangeReport), new XNavItemCat[]{ATS_ADVANCED_SEARCHES}));
        this.items.add((XNavigateItem)new XNavigateItemOperation((OseeImage)AtsImage.OPEN_BY_ID, "Search by ID(s) - Open World Editor", (IOperationFactory)new MultipleIdSearchOperationFactory("Search by ID(s) - Open World Editor", AtsEditor.WorldEditor), new XNavItemCat[]{ATS_ADVANCED_SEARCHES}));
        this.items.add((XNavigateItem)new XNavigateItemOperation((OseeImage)AtsImage.OPEN_BY_ID, "Search by ID(s) - Multi-Line - Open World Editor", (IOperationFactory)new MultipleIdMultiLineSearchOperationFactory("Search by ID(s) - Open World Editor", AtsEditor.WorldEditor), new XNavItemCat[]{ATS_ADVANCED_SEARCHES}));
        this.items.add((XNavigateItem)new XNavigateItemOperation((OseeImage)AtsImage.WORKFLOW, "Search by ID(s) - Open Workflow Editor", (IOperationFactory)new MultipleIdSearchOperationFactory("Search by ID(s) - Open Workflow Editor", AtsEditor.WorkflowEditor), new XNavItemCat[]{ATS_ADVANCED_SEARCHES}));
        this.items.add((XNavigateItem)new XNavigateItemOperation((OseeImage)AtsImage.GLOBE, "Action Quick Search", (IOperationFactory)new AtsQuickSearchOperationFactory(), new XNavItemCat[]{ATS_ADVANCED_SEARCHES}));
        time.end();
    }

    private void addAdminItems() {
        ElapsedTime time = new ElapsedTime("NVI - admin", debug);
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (KeyedImage)PluginUiImage.ADMIN, new XNavItemCat[]{XNavItemCat.MID_TOP, XNavItemCat.OSEE_ADMIN}));
            this.items.add((XNavigateItem)new XNavigateItemBlam((AbstractBlam)new ConvertWorkflowStatesBlam(), XNavigateItem.TOP_ADMIN));
            this.items.add((XNavigateItem)new DisplayCurrentOseeEventListeners());
            this.items.add((XNavigateItem)new XNavigateItemBlam((AbstractBlam)new CreateAtsBaselineBranchBlam(), XNavigateItem.TOP_ADMIN));
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenChangeReportByTransactionIdAction(), (KeyedImage)FrameworkImage.BRANCH_CHANGE, new XNavItemCat[]{XNavigateItem.TOP_ADMIN}));
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenArtifactEditorById(), (KeyedImage)FrameworkImage.ARTIFACT_EDITOR, new XNavItemCat[]{XNavigateItem.TOP_ADMIN}));
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new PurgeTransactionAction(), (KeyedImage)FrameworkImage.PURGE, new XNavItemCat[]{XNavigateItem.TOP_ADMIN}));
            this.items.add((XNavigateItem)new CleanupOseeSystemAssignedWorkflows());
        }
        time.end();
    }

    private void addEmailItems() {
        ElapsedTime time = new ElapsedTime("NVI - email", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.EMAIL_NOTIFICATIONS.getName(), (KeyedImage)FrameworkImage.EMAIL, new XNavItemCat[]{XNavItemCat.BOT}));
        this.items.add((XNavigateItem)new EmailTeamsItem(null, EmailTeamsItem.MemberType.Both));
        this.items.add((XNavigateItem)new EmailTeamsItem(null, EmailTeamsItem.MemberType.Leads));
        this.items.add((XNavigateItem)new EmailTeamsItem(null, EmailTeamsItem.MemberType.Members));
        this.items.add((XNavigateItem)new EmailUserGroups());
        this.items.add((XNavigateItem)new SubscribeByActionableItem());
        this.items.add((XNavigateItem)new SubscribeByTeamDefinition());
        this.items.add((XNavigateItem)new XNavigateItemBlam((AbstractBlam)new EmailActionsBlam(), (KeyedImage)FrameworkImage.EMAIL, new XNavItemCat[]{XNavigateItem.EMAIL_NOTIFICATIONS}));
        time.end();
    }

    private void addTraceItems() {
        this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.TRACE.getName(), (KeyedImage)FrameworkImage.TRACE, new XNavItemCat[]{XNavItemCat.MID_BOT}));
    }

    private void addReportItems() {
        ElapsedTime time = new ElapsedTime("NVI - report", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.REPORTS.getName(), (OseeImage)AtsImage.REPORT, new XNavItemCat[]{XNavItemCat.MID_BOT}));
        this.items.add((XNavigateItem)new FirstTimeQualityMetricReportItem());
        time.end();
    }

    private void addGoalItems() {
        ElapsedTime time = new ElapsedTime("NVI - goal", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder(GOALS.getName(), (OseeImage)AtsImage.GOAL, new XNavItemCat[]{XNavItemCat.MID_BOT}));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new NewGoal(), (OseeImage)AtsImage.GOAL, new XNavItemCat[]{GOALS}));
        time.end();
    }

    private void addExampleItems() {
        ElapsedTime time = new ElapsedTime("NVI - example", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder("Examples", (KeyedImage)FrameworkImage.EXAMPLE, new XNavItemCat[]{XNavigateItem.UTILITY_EXAMPLES, XNavItemCat.SUBCAT}));
        this.items.add((XNavigateItem)new ResultsEditorExample());
        this.items.add((XNavigateItem)new CompareEditorExample());
        this.items.add((XNavigateItem)new XViewerExample());
        this.items.add((XNavigateItem)new XResultDataExample());
        this.items.add((XNavigateItem)new XResultDataDialogExample());
        this.items.add((XNavigateItem)new XResultDataTableExample());
        this.items.add((XNavigateItem)new FilteredTreeDialogExample());
        this.items.add((XNavigateItem)new FilteredTreeDialogSingleExample());
        this.items.add((XNavigateItem)new FilteredTreeArtifactDialogExample());
        this.items.add((XNavigateItem)new FilteredCheckboxTreeDialogExample());
        this.items.add((XNavigateItem)new FilteredCheckboxTreeArtifactDialogExample());
        this.items.add((XNavigateItem)new FilteredCheckboxTreeDialogSelectAllExample());
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new XWidgetsDialogExampleAction(), (KeyedImage)FrameworkImage.EXAMPLE, new XNavItemCat[]{XNavigateItem.UTILITY_EXAMPLES}));
        time.end();
    }

    private void addWorkDefinitionsItems() {
        ElapsedTime time = new ElapsedTime("NVI - workDef", debug);
        this.items.add((XNavigateItem)new XNavigateItemFolder("Work Definition", (OseeImage)AtsImage.WORKFLOW_DEFINITION, new XNavItemCat[]{ATS_WORK_DEFINITION, XNavItemCat.SUBCAT}));
        this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (OseeImage)AtsImage.WORKFLOW_DEFINITION, new XNavItemCat[]{ATS_WORK_DEFINITION_ADMIN, XNavItemCat.SUBCAT, XNavItemCat.OSEE_ADMIN}));
        try {
            this.items.add((XNavigateItem)new WorkDefinitionViewer(ATS_WORK_DEFINITION));
            this.items.add(new ValidateWorkDefinitionNavigateItem(ATS_WORK_DEFINITION_ADMIN));
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Goals section");
        }
        time.end();
    }

    private void addVersionsItems() {
        ElapsedTime time = new ElapsedTime("NVI - version", debug);
        try {
            this.items.add((XNavigateItem)new XNavigateItemFolder("Versions", (OseeImage)AtsImage.VERSION, new XNavItemCat[]{ATS_VERSIONS, XNavItemCat.SUBCAT}));
            this.items.add((XNavigateItem)new XNavigateItemFolder("Admin", (OseeImage)AtsImage.VERSION, new XNavItemCat[]{ATS_VERSIONS_ADMIN, XNavItemCat.SUBCAT, XNavItemCat.OSEE_ADMIN}));
            this.items.add((XNavigateItem)new ParallelConfigurationView());
            this.items.add(new SearchNavigateItem((WorldSearchItem)new VersionTargetedForTeamSearchItem(null, null, false, WorldSearchItem.LoadView.WorldEditor), ATS_VERSIONS));
            this.items.add(new SearchNavigateItem((WorldSearchItem)new NextVersionSearchItem(null, WorldSearchItem.LoadView.WorldEditor), ATS_VERSIONS));
            this.items.add((XNavigateItem)new GenerateVersionReportItem());
            this.items.add((XNavigateItem)new GenerateFullVersionReportItem());
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                this.items.add((XNavigateItem)new MassEditTeamVersionItem("Team Versions (Admin)", (KeyedImage)FrameworkImage.VERSION));
                this.items.add((XNavigateItem)new CreateNewVersionItem(null));
                this.items.add((XNavigateItem)new ReleaseVersionItem(null));
            }
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Versions section");
        }
        time.end();
    }

    private void addReviewItems() {
        this.items.add((XNavigateItem)new XNavigateItemFolder(REVIEW.getName(), (OseeImage)AtsImage.REVIEW, new XNavItemCat[]{XNavItemCat.MID_BOT}));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new MyReviewSearchItem(), REVIEW));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchReviewSearchItem(), REVIEW));
        this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenWorkflowByIdAction("Open Review by ID"), (OseeImage)AtsImage.REVIEW, new XNavItemCat[]{REVIEW}));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new ShowOpenWorkflowsByReviewType("Show Open " + WorkItemType.DecisionReview.name() + "s", WorkItemType.DecisionReview, false, false, AtsImage.DECISION_REVIEW), REVIEW));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new ShowOpenWorkflowsByReviewType("Show Workflows Waiting " + WorkItemType.DecisionReview.name() + "s", WorkItemType.DecisionReview, false, true, AtsImage.DECISION_REVIEW), REVIEW));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new ShowOpenWorkflowsByReviewType("Show Open " + WorkItemType.PeerReview.name() + "s", WorkItemType.PeerReview, false, false, AtsImage.PEER_REVIEW), REVIEW));
        this.items.add(new SearchNavigateItem((WorldSearchItem)new ShowOpenWorkflowsByReviewType("Show Workflows Waiting " + WorkItemType.PeerReview.name() + "s", WorkItemType.PeerReview, false, true, AtsImage.PEER_REVIEW), REVIEW));
        this.items.add((XNavigateItem)new NewPeerToPeerReviewItem());
        this.items.add((XNavigateItem)new GenerateReviewParticipationReport());
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            this.items.add((XNavigateItem)new XNavigateItemAction((Action)new ValidatePeerDefectsAction(), (OseeImage)AtsImage.PEER_REVIEW, new XNavItemCat[]{REVIEW}));
        }
    }

    private void addPleItems() {
        ElapsedTime time = new ElapsedTime("NVI - addPleItems", debug);
        try {
            String applicationServer = System.getProperty("osee.application.server", "");
            this.items.add((XNavigateItem)new XNavigateItemFolder(XNavigateItem.PLE.getName(), (KeyedImage)FrameworkImage.PLE, new XNavItemCat[]{XNavItemCat.TOP, XNavigateItem.PLE}));
            this.items.add((XNavigateItem)new XNavigateUrlItem("Product Line (PL) Dashboard", String.valueOf(applicationServer) + "/osee/ple", true, (KeyedImage)FrameworkImage.PLE, XNavigateItem.PLE));
            this.items.add((XNavigateItem)new XNavigateUrlItem("Product Line Configuration (PLConfig)", String.valueOf(applicationServer) + "/osee/ple/plconfig", true, (KeyedImage)FrameworkImage.PLE, XNavigateItem.PLE));
            this.items.add((XNavigateItem)new XNavigateUrlItem("Message Interface Modeling (MIM)", String.valueOf(applicationServer) + "/osee/ple/messaging", true, (KeyedImage)FrameworkImage.PLE, XNavigateItem.PLE));
            this.items.add((XNavigateItem)new XNavigateUrlItem("PLE - Getting Started", "https://git.eclipse.org/c/gerrit/osee/org.eclipse.osee.git/plain/plugins/org.eclipse.osee.support.admin/presentations_publications/Disciplined_Engineering_with_OSEE.pptx", true, (KeyedImage)FrameworkImage.PPTX, XNavigateItem.PLE));
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create PLE section");
        }
        time.end();
    }

    private void addEvNavigateItems() {
        ElapsedTime time = new ElapsedTime("NVI - addUserItems", debug);
        try {
            if (AgileUtil.isEarnedValueUser((AtsApi)AtsApiService.get())) {
                this.items.add((XNavigateItem)new XNavigateItemFolder("Earned Value", (OseeImage)AtsImage.REPORT, new XNavItemCat[]{ATS_EARNED_VALUE, XNavItemCat.SUBCAT}));
                this.items.add((XNavigateItem)new XNavigateItemAction((Action)new OpenWorkPackageByIdAction(), (OseeImage)AtsImage.WORK_PACKAGE, new XNavItemCat[]{ATS_EARNED_VALUE}));
                this.items.add((XNavigateItem)new WorkPackageConfigReport());
                this.items.add((XNavigateItem)new WorkPackageQBDReport());
                this.items.add(new SearchNavigateItem((WorldSearchItem)new AtsSearchWorkPackageSearchItem(), ATS_EARNED_VALUE));
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    public static boolean isDebug() {
        return false;
    }

    private static final class MultipleIdMultiLineSearchOperationFactory
    implements IOperationFactory {
        private final AtsEditor atsEditor;
        private final String operationName;

        public MultipleIdMultiLineSearchOperationFactory(String operationName, AtsEditor atsEditor) {
            this.operationName = operationName;
            this.atsEditor = atsEditor;
        }

        public IOperation createOperation() {
            MultipleIdSearchOperation op = new MultipleIdSearchOperation(new MultipleIdSearchData(this.operationName, this.atsEditor));
            op.setMultiLine(true);
            return op;
        }
    }

    private static final class MultipleIdSearchOperationFactory
    implements IOperationFactory {
        private final AtsEditor atsEditor;
        private final String operationName;

        public MultipleIdSearchOperationFactory(String operationName, AtsEditor atsEditor) {
            this.operationName = operationName;
            this.atsEditor = atsEditor;
        }

        public IOperation createOperation() {
            return new MultipleIdSearchOperation(new MultipleIdSearchData(this.operationName, this.atsEditor));
        }
    }
}

