/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.activity.api.ActivityEntryId;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.NavigateItemCollector;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class AtsNavigateComposite
extends XNavigateComposite {
    public AtsNavigateComposite(NavigateItemCollector navigateItemCollector, Composite parent, int style, String filterText) {
        super(navigateItemCollector, parent, style, filterText);
        Result result = DbConnectionUtility.areOSEEServicesAvailable();
        if (result.isFalse()) {
            new Label(parent, 0).setText(result.getText());
            return;
        }
    }

    protected void handleDoubleClick() {
        IStructuredSelection sel = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
        if (!sel.iterator().hasNext()) {
            return;
        }
        XNavigateItem item = (XNavigateItem)sel.iterator().next();
        this.handleDoubleClick(item, new XNavigateComposite.TableLoadOption[0]);
    }

    protected void handleDoubleClick(XNavigateItem item, XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        super.disposeTooltip();
        if (item.getChildren().size() > 0) {
            this.filteredTree.getViewer().setExpandedState((Object)item, true);
        }
        ActivityLogEndpoint activityEp = AtsApiService.get().getOseeClient().getActivityLogEndpoint();
        ActivityEntryId activityId = null;
        try {
            activityId = activityEp.createEntry((ActivityTypeId)CoreActivityTypes.XNAVIGATEITEM, Long.valueOf(0L), ActivityLog.INITIAL_STATUS, item.getName());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Eror creating activity log entry", (Throwable)ex);
        }
        try {
            item.run(tableLoadOptions);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        try {
            if (activityId != null) {
                activityEp.updateEntry(activityId.getId(), ActivityLog.COMPLETE_STATUS);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Eror updating activity log entry", (Throwable)ex);
        }
    }
}

