/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osee.ats.ide.editor.WfeInput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class WfeInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.osee.ats.ide.WEEditorInputFactory";
    public static final String ART_KEY = "org.eclipse.osee.ats.ide.WEEditorInputFactory.artId";
    public static final String ART_KEY_AS_LONG = "org.eclipse.osee.ats.ide.WEEditorInputFactory.artIdAsLong";
    public static final String BRANCH_KEY = "org.eclipse.osee.ats.ide.WEEditorInputFactory.branchId";
    public static final String TITLE = "org.eclipse.osee.ats.ide.WEEditorInputFactory.title";

    public IAdaptable createElement(IMemento memento) {
        String artKeyAsInt;
        String branchStr = memento.getString(BRANCH_KEY);
        BranchId branch = branchStr == null ? BranchId.SENTINEL : BranchId.valueOf((String)branchStr);
        String artKeyAsLong = memento.getString(ART_KEY_AS_LONG);
        ArtifactId artifactId = Strings.isValid((String)artKeyAsLong) ? ArtifactId.valueOf((String)artKeyAsLong) : ((artKeyAsInt = memento.getString(ART_KEY)) == null ? ArtifactId.SENTINEL : ArtifactId.valueOf((String)artKeyAsInt));
        String title = memento.getString(TITLE);
        return new WfeInput(branch, artifactId, title);
    }

    public static void saveState(IMemento memento, WfeInput input) {
        ArtifactId artifactId = input.getArtId();
        BranchId branch = input.getBranchId();
        String title = input.getSavedTitle();
        if (input.getArtifact() != null && !input.getArtifact().isDeleted()) {
            artifactId = input.getArtifact();
            branch = input.getArtifact().getBranch();
            title = input.getName();
        }
        if (artifactId.isValid() && branch.isValid() && Strings.isValid((String)title)) {
            memento.putString(BRANCH_KEY, branch.getIdString());
            memento.putInteger(ART_KEY, artifactId.getId().intValue());
            memento.putString(ART_KEY_AS_LONG, artifactId.getIdString());
            memento.putString(TITLE, title);
        }
    }
}

