/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.column.AtsColumnIdValueColumn;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class AtsColumnIdUi
extends XViewerAtsColumn
implements IAtsXViewerPreComputedColumn {
    private final AtsColumnIdValueColumn columnIdColumn;
    private final AtsApi atsApi;

    public AtsColumnIdUi(AtsColumnIdValueColumn columnIdColumn, AtsApi atsApi) {
        super(columnIdColumn.getId(), columnIdColumn.getName(), columnIdColumn.getWidth(), AtsColumnIdUi.getXViewerAlign(columnIdColumn.getAlign()), columnIdColumn.isVisible(), SortDataType.valueOf((String)columnIdColumn.getSortDataType()), columnIdColumn.isColumnMultiEdit(), columnIdColumn.getDescription());
        this.columnIdColumn = columnIdColumn;
        this.atsApi = atsApi;
        this.setInheritParent(columnIdColumn.isInheritParent());
        this.setActionRollup(columnIdColumn.isActionRollup());
    }

    public AtsColumnIdUi copy() {
        AtsColumnIdUi newXCol = new AtsColumnIdUi(this.columnIdColumn, this.atsApi);
        super.copy(this, newXCol);
        return newXCol;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        for (Object element : objects) {
            String value = "";
            try {
                if (element instanceof IAtsObject) {
                    value = this.atsApi.getColumnService().getColumnText(this.columnIdColumn.getColumnId(), (IAtsObject)element);
                }
            }
            catch (Exception ex) {
                value = LogUtil.getCellExceptionString((Exception)ex);
            }
            preComputedValueMap.put(this.getKey(element), value);
        }
    }

    public static XViewerAlign getXViewerAlign(ColumnAlign align) {
        if (align == ColumnAlign.Center) {
            return XViewerAlign.Center;
        }
        if (align == ColumnAlign.Right) {
            return XViewerAlign.Right;
        }
        return XViewerAlign.Left;
    }
}

