/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.core.agile.AgileUtil;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileFeatureGroup;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileSprint;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileTeam;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileSprint;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileSprintReports;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileStoredSprintReports;
import org.eclipse.osee.ats.ide.agile.navigate.SortAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.SyncJiraAndOseeByEpicBlam;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.navigate.ConvertVersionToAgileSprint;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemFolder;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.widgets.xnavigate.XNavigateItemBlam;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class AgileNavigateItemProvider
implements XNavigateItemProvider {
    public static final XNavItemCat AGILE = new XNavItemCat("Agile");
    public static final XNavItemCat AGILE_REPORTS = new XNavItemCat("Agile.Reports");
    public static final XNavItemCat AGILE_CONFIG = new XNavItemCat("Agile.Configuration");
    public static final XNavItemCat AGILE_CONVERSIONS = new XNavItemCat("Agile.Conversions");

    public boolean isApplicable() {
        return AgileUtil.isAgileUser((AtsApi)AtsApiService.get());
    }

    public List<XNavigateItem> getNavigateItems(List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - agile section", AtsNavigateViewItems.debug);
        try {
            items.add((XNavigateItem)new XNavigateItemFolder(AGILE.getName(), AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_TEAM), new XNavItemCat[]{XNavItemCat.MID}));
            items.add((XNavigateItem)new XNavigateItemFolder("Reports", (OseeImage)AtsImage.REPORT, new XNavItemCat[]{AGILE_REPORTS, XNavItemCat.SUBCAT}));
            items.add((XNavigateItem)new XNavigateItemFolder("Configuration", (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{AGILE_CONFIG, XNavItemCat.SUBCAT}));
            items.add((XNavigateItem)new XNavigateItemFolder("Conversions", (KeyedImage)FrameworkImage.VERSION, new XNavItemCat[]{AGILE_CONVERSIONS, XNavItemCat.SUBCAT}));
            items.add((XNavigateItem)new OpenAgileBacklog());
            items.add((XNavigateItem)new OpenAgileSprint());
            items.add((XNavigateItem)new SortAgileBacklog());
            items.add((XNavigateItem)new OpenAgileSprintReports());
            items.add((XNavigateItem)new OpenAgileStoredSprintReports());
            items.add((XNavigateItem)new XNavigateItemBlam((AbstractBlam)new SyncJiraAndOseeByEpicBlam(), AGILE_REPORTS));
            items.add((XNavigateItem)new CreateNewAgileTeam());
            items.add((XNavigateItem)new CreateNewAgileFeatureGroup());
            items.add((XNavigateItem)new CreateNewAgileSprint());
            items.add((XNavigateItem)new CreateNewAgileBacklog());
            items.add((XNavigateItem)new ConvertVersionToAgileSprint());
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Agile section");
        }
        time.end();
        return items;
    }
}

