/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.define.api.MSWordOperations;
import org.eclipse.osee.define.api.PublishingOptions;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.WordUpdateChange;
import org.eclipse.osee.define.api.WordUpdateData;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUpdateArtifact;
import org.eclipse.osee.define.rest.internal.wordupdate.WordUtilities;
import org.eclipse.osee.define.rest.publishing.SpecifiedTemplatePublisherStreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.service.event.EventAdmin;

public class MSWordOperationsImpl
implements MSWordOperations {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final Log logger;
    private final EventAdmin eventAdmin;

    public MSWordOperationsImpl(OrcsApi orcsApi, AtsApi atsApi, Log logger, EventAdmin eventAdmin) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.logger = logger;
        this.eventAdmin = eventAdmin;
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData data) {
        WordTemplateContentRendererHandler wordRendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
        return wordRendererHandler.renderWordML(data);
    }

    public String renderPlainText(BranchId branchId, String data) {
        int lastIndex;
        String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
        String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
        String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
        String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
        Pattern REVIEW_COMMENT = Pattern.compile("<aml:annotation[^>]*w:type=\"Word.Comment.Start\"/?>(</aml:annotation>)?[\\s\\S]+?<aml:annotation[^>]*w:type=\"Word.Comment.End\"/?>(</aml:annotation>)?[\\s\\S]+?</aml:annotation></w:r>");
        data = WordUtilities.reassignBinDataID(data);
        data = WordMlLinkHandler.renderPlainTextWithoutLinks(this.orcsApi.getQueryFactory(), branchId, data);
        data = WordUtilities.reassignBookMarkID(data);
        data = WordUtilities.removeNewLines(data);
        data = data.replaceAll("<w:p[^>]*><w:pPr>(<w:spacing w:after=\"[\\d]*\"[^>]*>)*(</w:spacing>)*<w:sectPr[^>]*>(<w:r><w:t>)?<w:ftr[^>]*>[\\s\\S]+</w:ftr>[\\s\\S]+</w:sectPr></w:pPr></w:p>", "");
        data = data.replaceAll("<w:sectPr[^>]*><w:ftr[\\s\\S]+?</w:ftr>[\\s\\S]+?</w:sectPr>", "");
        data = data.replaceAll("<w:sectPr[^>]*>(<w:type[^>]*>(</w:type>)*)*<w:pgSz[^>]*>(</w:pgSz>)*<w:pgMar[^>]*>(</w:pgMar>)*<w:cols[^>]*>(</w:cols>)*</w:sectPr>", "<w:r><w:br w:type=\"page\"/></w:r>");
        if (!(data = data.replaceAll("<w:p>[\\s||\\S]+?<w:r><w:t>NO DATA RIGHTS ARTIFACT FOUND</w:t></w:r>[\\s\\S]+?</w:p>", "")).contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = data.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            data = String.valueOf(data.substring(0, lastIndex)) + temp;
        }
        data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
        data = data.replaceAll(PL_STYLE, "");
        data = data.replaceAll(PL_HIGHLIGHT, "");
        Matcher commentMatch = REVIEW_COMMENT.matcher(data = data.replaceAll(EMPTY_PARAGRAPHS, ""));
        if (commentMatch.find()) {
            data = data.replaceAll("<aml:annotation[^>]*w:type=\"Word.Comment.Start\"/?>(</aml:annotation>)?", "");
            data = data.replaceAll("<aml:annotation[^>]*w:type=\"Word.Comment.End\"/?>(</aml:annotation>)?", "");
            data = data.replaceAll("<w:r[^>]*><w:rPr><w:rStyle w:val=\"CommentReference\"/?>(</w:rStyle>)?</w:rPr><aml:annotation[^>]*w:type=\"Word.Comment\"[^>]*><aml:content>[\\s\\S]+?</aml:content></aml:annotation></w:r>", "");
        }
        return data;
    }

    public String renderWordTemplateContentWithApplicability(BranchId branchId, ArtifactId viewId, String data) {
        WordMLApplicabilityHandler wordHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, branchId, viewId);
        return wordHandler.previewValidApplicabilityContent(data);
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData data) {
        WordUpdateArtifact updateArt = new WordUpdateArtifact(this.logger, this.orcsApi, this.eventAdmin);
        return updateArt.updateArtifacts(data);
    }

    public Response msWordTemplatePublish(BranchId branch, ArtifactId template, ArtifactId headArtifact, ArtifactId view) {
        String name = this.orcsApi.getQueryFactory().fromBranch(branch).andId(headArtifact).asArtifactToken().getName();
        SimpleDateFormat format = new SimpleDateFormat("MM-dd_HH-mm-ss");
        Date date = new Date(System.currentTimeMillis());
        String time = format.format(date);
        String fileName = String.valueOf(name) + "_" + time + ".xml";
        PublishingOptions publishingOptions = new PublishingOptions();
        publishingOptions.branch = branch;
        publishingOptions.linkType = LinkType.INTERNAL_DOC_REFERENCE_USE_NAME;
        publishingOptions.excludeFolders = true;
        publishingOptions.view = view;
        SpecifiedTemplatePublisherStreamingOutput streamingOutput = new SpecifiedTemplatePublisherStreamingOutput(publishingOptions, template, headArtifact, this.orcsApi, this.atsApi);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }
}

