/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageEndpoint;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;

public class InterfaceMessageEndpointImpl
implements InterfaceMessageEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId ConnectionId;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;

    public InterfaceMessageEndpointImpl(BranchId branch, ArtifactId connectionId, UserId account, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi) {
        this.account = account;
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.ConnectionId = connectionId;
    }

    @Override
    public Collection<InterfaceMessageToken> getAllMessages() {
        try {
            List messageList = (List)this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceConnectionContent_Connection, this.ConnectionId, InterfaceMessageToken.class);
            for (InterfaceMessageToken message : messageList) {
                LinkedList<InterfaceSubMessageToken> submessages = new LinkedList<InterfaceSubMessageToken>();
                for (InterfaceSubMessageToken submessage : this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceSubMessageToken.class)) {
                    submessages.add(submessage);
                }
                message.setSubMessages(submessages);
            }
            return messageList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceMessageToken getInterfaceMessage(ArtifactId messageId) {
        try {
            InterfaceMessageToken message = this.messageApi.getAccessor().getByRelation(this.branch, messageId, CoreRelationTypes.InterfaceConnectionContent_Connection, this.ConnectionId, InterfaceMessageToken.class);
            LinkedList<InterfaceSubMessageToken> submessages = new LinkedList<InterfaceSubMessageToken>();
            for (InterfaceSubMessageToken submessage : this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceSubMessageToken.class)) {
                submessages.add(submessage);
            }
            message.setSubMessages(submessages);
            return message;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

