/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;

public class CountingMap<K> {
    private final HashMap<K, MutableInteger> countingMap;

    public CountingMap(int initialCapacity) {
        this.countingMap = new HashMap(initialCapacity);
    }

    public CountingMap() {
        this.countingMap = new HashMap();
    }

    public int get(K key) {
        MutableInteger count = this.countingMap.get(key);
        if (count == null) {
            return 0;
        }
        return count.getValue();
    }

    public boolean contains(K key) {
        return this.countingMap.containsKey(key);
    }

    public void put(K key) {
        MutableInteger count = this.countingMap.get(key);
        if (count == null) {
            this.countingMap.put(key, new MutableInteger(1));
        } else {
            count.getValueAndInc();
        }
    }

    public void put(K key, int byAmt) {
        MutableInteger count = this.countingMap.get(key);
        if (count == null) {
            this.countingMap.put(key, new MutableInteger(byAmt));
        } else {
            count.getValueAndInc(byAmt);
        }
    }

    public void put(Collection<K> keys) {
        for (K key : keys) {
            this.put(key);
        }
    }

    public Set<Map.Entry<K, MutableInteger>> getCounts() {
        return this.countingMap.entrySet();
    }

    public void clear() {
        this.countingMap.clear();
    }

    public String toString() {
        return this.countingMap.toString();
    }
}

