/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;

public class BatFileProcessor {
    private final BlockApplicabilityOps orcsApplicability;
    private final FileTypeApplicabilityData fileTypeApplicabilityData;
    private final Stack<ApplicabilityBlock> applicBlocks = new Stack();
    private final boolean isConfig;
    private final boolean commentNonApplicableBlocks;
    private final XResultData results = new XResultData();
    private final String charsetString = "UTF8";
    private boolean tagProcessed = false;

    public BatFileProcessor(BlockApplicabilityOps orcsApplicability, FileTypeApplicabilityData fileTypeApplicabilityData, boolean isConfig, boolean commentNonApplicableBlocks) {
        this.orcsApplicability = orcsApplicability;
        this.fileTypeApplicabilityData = fileTypeApplicabilityData;
        this.isConfig = isConfig;
        this.commentNonApplicableBlocks = commentNonApplicableBlocks;
        this.results.setLogToSysErr(true);
    }

    public boolean processFile(File inFile, File outFile) throws IOException {
        if (inFile.exists()) {
            CharBuffer fileContent = this.applyApplicabilityContent(inFile);
            if (this.tagProcessed) {
                this.results.logf("Applicability was applied to %s\n", new Object[]{inFile.getName()});
                if (fileContent != null) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    writer.write(fileContent.array());
                    writer.close();
                }
            }
        }
        return this.tagProcessed;
    }

    private CharBuffer applyApplicabilityContent(File inFile) throws IOException {
        CharBuffer fileContent = Lib.fileToCharBuffer((File)inFile, (String)"UTF8");
        String toReturn = fileContent.toString();
        Matcher matcher = this.fileTypeApplicabilityData.getCommentedTagPattern().matcher(toReturn);
        int matcherIndex = 0;
        while (matcherIndex < toReturn.length() && matcher.find(matcherIndex)) {
            String applicabilityExpression;
            ApplicabilityBlock.ApplicabilityType applicabilityType;
            String beginFeature = matcher.group(1);
            String endFeature = matcher.group(6);
            String beginConfig = matcher.group(11);
            String endConfig = matcher.group(17);
            String beginConfigGrp = matcher.group(22);
            String endConfigGrp = matcher.group(28);
            if (beginFeature != null) {
                applicabilityType = ApplicabilityBlock.ApplicabilityType.Feature;
                applicabilityExpression = matcher.group(2);
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginFeature, applicabilityExpression);
                continue;
            }
            if (beginConfig != null) {
                applicabilityExpression = matcher.group(12);
                applicabilityType = ApplicabilityBlock.ApplicabilityType.Configuration;
                if (beginConfig.contains("Not")) {
                    applicabilityType = ApplicabilityBlock.ApplicabilityType.NotConfiguration;
                }
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginConfigGrp, applicabilityExpression);
                continue;
            }
            if (beginConfigGrp != null) {
                applicabilityExpression = matcher.group(23);
                applicabilityType = ApplicabilityBlock.ApplicabilityType.ConfigurationGroup;
                if (beginConfigGrp.contains("Not")) {
                    applicabilityType = ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup;
                }
                matcherIndex = this.startApplicabilityBlock(applicabilityType, matcher, beginConfigGrp, applicabilityExpression);
                continue;
            }
            if (endFeature != null || endConfig != null || endConfigGrp != null) {
                if (this.applicBlocks.isEmpty()) {
                    this.results.warningf("An Applicability End tag was found before a beginning tag for %s\n", new Object[]{inFile.getPath()});
                    this.tagProcessed = false;
                    return fileContent;
                }
                ApplicabilityBlock applicBlock = this.finishApplicabilityBlock(toReturn, matcher);
                String toReplace = toReturn.substring(applicBlock.getStartInsertIndex(), applicBlock.getEndInsertIndex());
                toReturn = toReturn.replace(toReplace, applicBlock.getInsideText());
                matcherIndex = applicBlock.getStartInsertIndex() + applicBlock.getInsideText().length();
                matcher = this.fileTypeApplicabilityData.getCommentedTagPattern().matcher(toReturn);
                this.tagProcessed = true;
                continue;
            }
            this.results.warningf("Did not find a start or end feature tag for %s but a similar tag was matched\n", new Object[]{inFile.getPath()});
            this.tagProcessed = false;
            return fileContent;
        }
        return CharBuffer.wrap(toReturn.toCharArray());
    }

    private int startApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicabilityType, Matcher matcher, String beginTag, String applicabilityExpression) {
        ApplicabilityBlock applicStart = new ApplicabilityBlock(applicabilityType);
        applicStart.setApplicabilityExpression(applicabilityExpression);
        applicStart.setStartInsertIndex(matcher.start());
        applicStart.setStartTextIndex(matcher.end());
        applicStart.setBeginTag(beginTag);
        this.applicBlocks.add(applicStart);
        return matcher.end();
    }

    private ApplicabilityBlock finishApplicabilityBlock(String toReturn, Matcher matcher) throws IOException {
        ApplicabilityBlock applicBlock = this.applicBlocks.pop();
        applicBlock.setEndTextIndex(matcher.start());
        applicBlock.setEndInsertIndex(matcher.end());
        String insideText = toReturn.subSequence(applicBlock.getStartTextIndex(), applicBlock.getEndTextIndex()).toString();
        applicBlock.setInsideText(insideText);
        String replacementText = this.orcsApplicability.evaluateApplicabilityExpression(applicBlock);
        if (!replacementText.isEmpty()) {
            if (!this.fileTypeApplicabilityData.getCommentPrefixRegex().isEmpty()) {
                replacementText = replacementText.replaceAll("[ \\t]*" + this.fileTypeApplicabilityData.getCommentPrefixRegex() + "[ \\t]*", "");
            }
            if (!this.fileTypeApplicabilityData.getCommentSuffixRegex().isEmpty()) {
                replacementText = replacementText.replaceAll("[ \\t]*" + this.fileTypeApplicabilityData.getCommentSuffixRegex() + "[ \\t]*", "");
            }
        }
        if (!this.isConfig && this.commentNonApplicableBlocks) {
            String fullText = toReturn.subSequence(applicBlock.getStartInsertIndex(), applicBlock.getEndInsertIndex()).toString();
            fullText = this.getCommentedString(fullText, this.fileTypeApplicabilityData.getCommentPrefix(), this.fileTypeApplicabilityData.getCommentSuffix());
            String commentedReplacementText = this.getCommentedString(replacementText, this.fileTypeApplicabilityData.getCommentPrefix(), this.fileTypeApplicabilityData.getCommentSuffix());
            replacementText = fullText.replace(commentedReplacementText, replacementText);
        }
        applicBlock.setInsideText(replacementText);
        return applicBlock;
    }

    private String getCommentedString(String text, String commentPrefix, String commentSuffix) throws IOException {
        String line;
        Pattern whitespacePattern = Pattern.compile("\\s*");
        BufferedReader reader = new BufferedReader(new StringReader(text));
        StringBuilder strB = new StringBuilder();
        String newLine = this.getNewLineFromFile(text);
        while ((line = reader.readLine()) != null) {
            if (!line.isEmpty()) {
                boolean noSuffix;
                boolean noPrefix;
                boolean bl = commentPrefix.isEmpty() ? true : (noPrefix = !line.contains(commentPrefix));
                boolean bl2 = commentSuffix.isEmpty() ? true : (noSuffix = !line.contains(commentSuffix));
                if (noPrefix && noSuffix) {
                    Matcher match = whitespacePattern.matcher(line);
                    if (match.find()) {
                        strB.append(match.group());
                    }
                    strB.append(commentPrefix);
                    strB.append(line.substring(match.end()));
                    strB.append(commentSuffix);
                } else {
                    strB.append(line);
                }
            }
            strB.append(newLine);
        }
        reader.close();
        return strB.toString();
    }

    private String getNewLineFromFile(String text) {
        Matcher matcher = Pattern.compile("\\r\\n|[\\n\\r]").matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return System.lineSeparator();
    }
}

