/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.AgileItem;
import org.eclipse.osee.ats.api.agile.AgileReportType;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileWriterResult;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxNewAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxNewAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.agile.atw.AtwNode;
import org.eclipse.osee.ats.api.agile.kanban.JaxKbSprint;
import org.eclipse.osee.ats.api.agile.kanban.KanbanRowType;
import org.eclipse.osee.ats.api.agile.program.JaxProgramBacklogItemUpdate;
import org.eclipse.osee.ats.api.agile.program.JaxProgramBaseItem;
import org.eclipse.osee.ats.api.agile.program.JaxProgramFeatureUpdate;
import org.eclipse.osee.ats.api.agile.program.UiGridProgram;
import org.eclipse.osee.ats.api.agile.sprint.SprintConfigurations;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.ILineChart;
import org.eclipse.osee.ats.api.util.RestResult;
import org.eclipse.osee.ats.api.util.UpdateLocation;
import org.eclipse.osee.ats.api.util.UpdateType;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.JaxAtsObjects;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.core.agile.SprintUtil;
import org.eclipse.osee.ats.core.agile.operations.SprintBurndownOperations;
import org.eclipse.osee.ats.core.agile.operations.SprintBurnupOperations;
import org.eclipse.osee.ats.core.util.chart.LineChart;
import org.eclipse.osee.ats.rest.internal.agile.SprintDataTableBuilder;
import org.eclipse.osee.ats.rest.internal.agile.SprintPageBuilder;
import org.eclipse.osee.ats.rest.internal.agile.operations.EndpointOperations;
import org.eclipse.osee.ats.rest.internal.agile.operations.KanbanOperations;
import org.eclipse.osee.ats.rest.internal.agile.operations.ProgramOperations;
import org.eclipse.osee.ats.rest.internal.agile.operations.SprintConfigOperations;
import org.eclipse.osee.ats.rest.internal.query.TokenSearchOperations;
import org.eclipse.osee.ats.rest.internal.world.AtsWorldEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ClassBasedResourceToken;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.template.engine.PageCreator;
import org.eclipse.osee.template.engine.PageFactory;

public class AgileEndpointImpl
implements AgileEndpointApi {
    @Context
    private UriInfo uriInfo;
    private final AtsApi atsApi;
    private final IResourceRegistry resourceRegistry;
    private final JdbcService jdbcService;
    private final OrcsApi orcsApi;
    private EndpointOperations endpointOps;

    public AgileEndpointImpl(AtsApi atsApi, IResourceRegistry resourceRegistry, JdbcService jdbcService, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.resourceRegistry = resourceRegistry;
        this.jdbcService = jdbcService;
        this.orcsApi = orcsApi;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Path(value="program/token")
    @GET
    @Produces(value={"application/json"})
    public List<JaxAtsObject> getProgramTokens() throws Exception {
        return this.getEndpointOps().getActiveArtifactTypeTokens(AtsArtifactTypes.AgileProgram, this.uriInfo);
    }

    private EndpointOperations getEndpointOps() {
        if (this.endpointOps == null) {
            this.endpointOps = new EndpointOperations(this.atsApi);
        }
        return this.endpointOps;
    }

    @GET
    @Path(value="program/{programId}/token")
    @Produces(value={"application/json"})
    public JaxAtsObject getProgramToken(@PathParam(value="programId") ArtifactId programId) {
        ArtifactToken token = this.atsApi.getQueryService().getArtifactToken(programId);
        return this.toAtsObjToken(token);
    }

    private JaxAtsObject toAtsObjToken(ArtifactToken token) {
        JaxAtsObject result = new JaxAtsObject();
        result.setName(token.getName());
        result.setId(token.getId());
        return result;
    }

    @GET
    @Path(value="program/{programId}/atw")
    @Produces(value={"application/json"})
    public String getProgramAtw(@PathParam(value="programId") long programId) throws Exception {
        IAgileProgram aProgram = this.atsApi.getAgileService().getAgileProgram(programId);
        ProgramOperations ops = new ProgramOperations(this.atsApi);
        AtwNode atwTree = ops.getAtwTree(aProgram);
        return "[" + this.orcsApi.jaxRsApi().toJson((Object)atwTree) + "]";
    }

    @GET
    @Path(value="program/{programId}/uigrid")
    @Produces(value={"application/json"})
    public UiGridProgram getProgramItems(@PathParam(value="programId") long programId) throws Exception {
        IAgileProgram aProgram = this.atsApi.getAgileService().getAgileProgram(programId);
        ProgramOperations ops = new ProgramOperations(this.atsApi);
        UiGridProgram progTree = ops.getUiGridTree(aProgram);
        return progTree;
    }

    private RestResult deleteProgramItem(long itemId, String itemName) {
        RestResult result = new RestResult();
        try {
            ArtifactToken programBacklogItem = this.atsApi.getQueryService().getArtifact(Long.valueOf(itemId));
            if (programBacklogItem == null) {
                result.getResult().errorf("Invalid %s Id %s", new Object[]{itemName, itemId});
            } else {
                IAtsChangeSet changes = this.atsApi.createChangeSet(String.format("Delete %s [%s]", itemName, programBacklogItem.toStringWithId()));
                changes.deleteArtifact((ArtifactId)programBacklogItem);
                changes.execute();
            }
        }
        catch (Exception ex) {
            result.getResult().errorf("Error deleting %s [%s]", new Object[]{itemName, Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JaxProgramBaseItem updateProgramItem(IAgileProgram program, JaxProgramBaseItem newItem, String itemName, ArtifactTypeToken artifactType, ArtifactToken parentArtifact) {
        if (!newItem.getType().equals((Object)UpdateType.New)) {
            newItem.getResults().errorf("Update Type %s not supported", new Object[]{newItem.getType()});
            return newItem;
        }
        if (!Strings.isValid((String)newItem.getTitle())) {
            newItem.getResults().errorf("Title must be specified", new Object[0]);
            return newItem;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(newItem.getType() + " " + itemName);
        ArtifactToken newitem = changes.createArtifact(artifactType, newItem.getTitle());
        ArtifactToken selectedItem = this.atsApi.getQueryService().getArtifact(newItem.getSelectedId());
        LinkedList<ArtifactToken> items = new LinkedList<ArtifactToken>();
        if (newItem.getLocation().equals((Object)UpdateLocation.First)) {
            items.add(newitem);
            items.addAll(this.atsApi.getRelationResolver().getChildren((ArtifactId)parentArtifact));
        } else if (newItem.getLocation().equals((Object)UpdateLocation.Last)) {
            items.addAll(this.atsApi.getRelationResolver().getChildren((ArtifactId)parentArtifact));
            items.add(newitem);
        } else if (newItem.getLocation().equals((Object)UpdateLocation.Selection)) {
            items.addAll(this.atsApi.getRelationResolver().getChildren((ArtifactId)parentArtifact));
            int index = items.indexOf(selectedItem);
            items.add(index, newitem);
        } else {
            if (!newItem.getLocation().equals((Object)UpdateLocation.AfterSelection)) {
                newItem.getResults().errorf("UpdateLocation %s not supported", new Object[]{newItem.getLocation()});
                return newItem;
            }
            items.addAll(this.atsApi.getRelationResolver().getChildren((ArtifactId)parentArtifact));
            int index = items.indexOf(selectedItem) + 1;
            items.add(index, newitem);
        }
        changes.setRelationsAndOrder((Object)parentArtifact, CoreRelationTypes.DefaultHierarchical_Child, items);
        changes.execute();
        newItem.setNewId(newitem.getId());
        return newItem;
    }

    @DELETE
    @Path(value="programbacklogitem/{programBacklogItemId}")
    public RestResult deleteProgramBacklogItem(@PathParam(value="programBacklogItemId") long programBacklogItemId) {
        return this.deleteProgramItem(programBacklogItemId, AtsArtifactTypes.AgileProgramBacklogItem.getName());
    }

    @POST
    @Path(value="program/{programId}/backlogitem")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxProgramBacklogItemUpdate updateProgramBacklogItem(@PathParam(value="programId") long programId, JaxProgramBacklogItemUpdate pBacklogItem) {
        IAgileProgram program = this.atsApi.getAgileService().getAgileProgram(programId);
        if (program == null) {
            pBacklogItem.getResults().errorf("Program Id %s not found", new Object[]{programId});
            return pBacklogItem;
        }
        ArtifactToken programBacklog = this.atsApi.getAgileService().getAgileProgramBacklogArt(program);
        JaxProgramBaseItem baseItem = this.updateProgramItem(program, (JaxProgramBaseItem)pBacklogItem, AtsArtifactTypes.AgileProgramBacklogItem.getName(), AtsArtifactTypes.AgileProgramBacklogItem, programBacklog);
        JaxAgileProgramBacklogItem newItem = JaxAgileProgramBacklogItem.construct((Long)programBacklog.getId(), (ArtifactToken)ArtifactToken.valueOf((ArtifactId)ArtifactId.valueOf((Long)baseItem.getNewId()), (String)pBacklogItem.getTitle()));
        pBacklogItem.setItem(newItem);
        return pBacklogItem;
    }

    @DELETE
    @Path(value="programfeature/{programFeatureId}")
    public RestResult deleteProgramFeature(@PathParam(value="programFeatureId") long programFeatureId) {
        return this.deleteProgramItem(programFeatureId, AtsArtifactTypes.AgileProgramFeature.getName());
    }

    @POST
    @Path(value="program/{programId}/feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JaxProgramFeatureUpdate updateProgramFeature(@PathParam(value="programId") long programId, JaxProgramFeatureUpdate featureItem) {
        IAgileProgram program = this.atsApi.getAgileService().getAgileProgram(programId);
        if (program == null) {
            featureItem.getResults().errorf("Program Id %s not found", new Object[]{programId});
            return featureItem;
        }
        ArtifactToken parentBacklogItem = this.atsApi.getQueryService().getArtifact(featureItem.getSelectedId());
        if (parentBacklogItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgramFeature})) {
            parentBacklogItem = this.atsApi.getRelationResolver().getParent((ArtifactId)parentBacklogItem);
        }
        JaxProgramBaseItem baseItem = this.updateProgramItem(program, (JaxProgramBaseItem)featureItem, AtsArtifactTypes.AgileProgramFeature.getName(), AtsArtifactTypes.AgileProgramFeature, parentBacklogItem);
        JaxAgileProgramFeature newItem = JaxAgileProgramFeature.construct((Long)parentBacklogItem.getId(), (ArtifactToken)ArtifactToken.valueOf((ArtifactId)ArtifactId.valueOf((Long)baseItem.getNewId()), (String)featureItem.getTitle()));
        featureItem.setItem(newItem);
        return featureItem;
    }

    public Response createProgramFeature(Long programId, JaxNewAgileProgramFeature newProgramFeature) {
        if (!Strings.isValid((String)newProgramFeature.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newProgramFeature.getProgramBacklogItemId() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "programBacklogItemId is not valid", new Object[0]);
        }
        String guid = GUID.create();
        Long id = newProgramFeature.getId();
        if (id == null || id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        IAgileProgramBacklogItem programBacklogItem = this.atsApi.getAgileService().getAgileProgramBacklogItem(newProgramFeature.getProgramBacklogItemId().longValue());
        IAgileProgramFeature programFeature = this.atsApi.getAgileService().createAgileProgramFeature(programBacklogItem.getId().longValue(), newProgramFeature.getName(), guid, id);
        JaxAgileProgramFeature newFeature = new JaxAgileProgramFeature();
        newFeature.setName(programFeature.getName());
        newFeature.setId(programFeature.getId());
        ArtifactToken featureArt = this.atsApi.getQueryService().getArtifact(programFeature.getId());
        boolean active = (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)featureArt, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        newFeature.setActive(active);
        ArtifactToken programBacklogItemArt = this.atsApi.getRelationResolver().getParent((ArtifactId)featureArt);
        newFeature.setProgramBacklogItemId(programBacklogItemArt.getId().longValue());
        return Response.ok().entity((Object)newFeature).build();
    }

    public String get() {
        return "Agile Resource";
    }

    @Path(value="team/token")
    @GET
    @Produces(value={"application/json"})
    public List<JaxAtsObject> getTeamTokens() throws Exception {
        return this.getEndpointOps().getActiveArtifactTypeTokens(AtsArtifactTypes.AgileTeam, this.uriInfo);
    }

    public List<JaxAgileTeam> team() throws Exception {
        ArrayList<JaxAgileTeam> teams = new ArrayList<JaxAgileTeam>();
        for (IAgileTeam team : this.atsApi.getAgileService().getTeams()) {
            teams.add(AgileFactory.createJaxTeam((IAgileTeam)team));
        }
        return teams;
    }

    public JaxAgileTeam getTeam(long teamId) {
        IAgileTeam team = this.atsApi.getAgileService().getAgileTeamById(teamId);
        return AgileFactory.createJaxTeam((IAgileTeam)team);
    }

    @GET
    @Path(value="team/{teamId}/token")
    @Produces(value={"application/json"})
    public ArtifactToken getTeamToken(@PathParam(value="teamId") ArtifactId teamId) {
        return this.atsApi.getQueryService().getArtifactToken(teamId);
    }

    @Path(value="team/{teamId}/workpackage")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkPackage> getWorkPackages(@PathParam(value="teamId") ArtifactId teamId) {
        IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeam(teamId);
        HashSet<IAtsWorkPackage> wps = new HashSet<IAtsWorkPackage>();
        for (Long atsTeamId : aTeam.getAtsTeamIds()) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(atsTeamId);
            if (teamDef == null) continue;
            for (ArtifactId wpArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)teamDef, AtsRelationTypes.TeamDefinitionToWorkPackage_WorkPackage)) {
                IAtsWorkPackage wp = (IAtsWorkPackage)this.atsApi.getQueryService().getConfigItem(wpArt);
                if (wp == null || !wp.isActive()) continue;
                wps.add(wp);
            }
            for (IAtsActionableItem ai : this.atsApi.getActionableItemService().getActiveActionableItemsAndChildren(teamDef)) {
                for (ArtifactId wpArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)ai, AtsRelationTypes.TeamDefinitionToWorkPackage_WorkPackage)) {
                    IAtsWorkPackage wp = (IAtsWorkPackage)this.atsApi.getQueryService().getConfigItem(wpArt);
                    if (wp == null || !wp.isActive()) continue;
                    wps.add(wp);
                }
            }
        }
        LinkedList<IAtsWorkPackage> wpList = new LinkedList<IAtsWorkPackage>();
        wpList.addAll(wps);
        Collections.sort(wpList, new NamedComparator(SortOrder.ASCENDING));
        return wpList;
    }

    @GET
    @Path(value="team/{teamId}/member")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getTeamMembers(@PathParam(value="teamId") ArtifactId teamId) {
        IAgileTeam aTeam = (IAgileTeam)this.atsApi.getQueryService().getConfigItem(teamId);
        List members = this.atsApi.getAgileService().getTeamMembersOrdered(aTeam);
        return members;
    }

    @GET
    @Path(value="team/{teamId}/memberOther")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getOtherMembers(@PathParam(value="teamId") ArtifactId teamId) {
        IAgileTeam aTeam = (IAgileTeam)this.atsApi.getQueryService().getConfigItem(teamId);
        List members = this.atsApi.getAgileService().getTeamMembersOrdered(aTeam);
        return members;
    }

    @Path(value="team/{teamId}/ai")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsActionableItem> getActionableAis(@PathParam(value="teamId") ArtifactId teamId) {
        IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeam(teamId);
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        for (IAtsTeamDefinition teamDef : this.atsApi.getAgileService().getAtsTeams(aTeam)) {
            ais.addAll(this.atsApi.getActionableItemService().getActiveActionableItemsAndChildren(teamDef));
        }
        for (ArtifactId aiArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)aTeam, AtsRelationTypes.AgileTeamToAtsAis_AtsAis)) {
            ais.add((IAtsActionableItem)this.atsApi.getActionableItemService().getActionableItemById(aiArt));
        }
        Collections.sort(ais, new NamedComparator(SortOrder.ASCENDING));
        return ais;
    }

    public Response createTeam(JaxNewAgileTeam newTeam) {
        if (!Strings.isValid((String)newTeam.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        Long id = newTeam.getId();
        if (id == null || id <= 0L) {
            newTeam.setId(Lib.generateArtifactIdAsInt());
        }
        IAgileTeam updatedTeam = this.atsApi.getAgileService().createAgileTeam(newTeam);
        JaxAgileTeam created = AgileFactory.createJaxTeam((IAgileTeam)updatedTeam);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getId())).build(new Object[0]);
        Response response = Response.created((URI)location).entity((Object)created).build();
        return response;
    }

    public Response updateTeam(JaxAgileTeam team) {
        IAgileTeam updatedTeam = this.atsApi.getAgileService().updateAgileTeam(team);
        JaxAgileTeam created = AgileFactory.createJaxTeam((IAgileTeam)updatedTeam);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getId())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    public Response deleteTeam(long teamId) {
        this.atsApi.getAgileService().deleteAgileTeam(teamId);
        return Response.ok().build();
    }

    public List<JaxAgileFeatureGroup> getFeatureGroups(long teamId) {
        LinkedList<JaxAgileFeatureGroup> groups = new LinkedList<JaxAgileFeatureGroup>();
        ArtifactToken agileTeamArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)agileTeamArt)) {
            if (!child.getName().equals("Feature Groups")) continue;
            for (ArtifactToken subChild : this.atsApi.getRelationResolver().getChildren((ArtifactId)child)) {
                if (!subChild.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) continue;
                IAgileFeatureGroup group = this.atsApi.getAgileService().getAgileFeatureGroup((ArtifactId)subChild);
                JaxAgileFeatureGroup newGroup = new JaxAgileFeatureGroup();
                newGroup.setName(group.getName());
                newGroup.setId(group.getId());
                newGroup.setActive(group.isActive());
                newGroup.setTeamId(group.getTeamId());
                groups.add(newGroup);
            }
        }
        return groups;
    }

    public Response createFeatureGroup(long teamId, JaxNewAgileFeatureGroup newFeatureGroup) {
        if (!Strings.isValid((String)newFeatureGroup.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newFeatureGroup.getTeamId() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamId is not valid", new Object[0]);
        }
        String guid = GUID.create();
        Long id = newFeatureGroup.getId();
        if (id == null || id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        IAgileFeatureGroup team = this.atsApi.getAgileService().createAgileFeatureGroup(newFeatureGroup.getTeamId(), newFeatureGroup.getName(), guid, id);
        JaxAgileFeatureGroup newGroup = new JaxAgileFeatureGroup();
        newGroup.setName(team.getName());
        newGroup.setId(team.getId());
        newGroup.setActive(team.isActive());
        newGroup.setTeamId(team.getTeamId());
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(newGroup.getTeamId())).path("features").path(String.valueOf(newGroup.getId())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)newGroup).build();
    }

    public JaxAgileFeatureGroup getFeatureGroup(long teamId, long featureId) {
        IAgileFeatureGroup feature = (IAgileFeatureGroup)this.atsApi.getAgileService().getAgileFeatureGroups(Arrays.asList(featureId)).iterator().next();
        JaxAgileFeatureGroup created = new JaxAgileFeatureGroup();
        created.setName(feature.getName());
        created.setId(feature.getId());
        created.setTeamId(feature.getTeamId());
        created.setActive(feature.isActive());
        return created;
    }

    public Response deleteFeatureGroup(long teamId, long featureId) {
        this.atsApi.getAgileService().deleteAgileFeatureGroup(featureId);
        return Response.ok().build();
    }

    public Response createSprint(long teamId, JaxNewAgileSprint newSprint) {
        if (!Strings.isValid((String)newSprint.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newSprint.getTeamId() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamId is not valid", new Object[0]);
        }
        Long id = newSprint.getId();
        if (id == null || id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        IAgileSprint sprint = this.atsApi.getAgileService().createAgileSprint(newSprint.getTeamId(), newSprint.getName(), id);
        JaxAgileSprint created = this.toJaxSprint(sprint);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(newSprint.getTeamId())).path("syncSprints").path(String.valueOf(sprint.getId())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    private JaxAgileSprint toJaxSprint(IAgileSprint sprint) {
        JaxAgileSprint created = new JaxAgileSprint();
        created.setName(sprint.getName());
        created.setActive(sprint.isActive());
        created.setId(sprint.getId());
        created.setTeamId(sprint.getTeamId());
        return created;
    }

    public List<JaxAgileSprint> getSprints(long teamId) {
        if (teamId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        ArrayList<JaxAgileSprint> sprints = new ArrayList<JaxAgileSprint>();
        for (IAgileSprint sprint : this.atsApi.getAgileService().getSprintsForTeam(teamId)) {
            sprints.add(this.toJaxSprint(sprint));
        }
        return sprints;
    }

    public List<ArtifactToken> getSprintsTokens(long teamId) {
        if (teamId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        Collection relatedSprints = this.atsApi.getQueryService().getRelatedToTokens((BranchId)this.atsApi.getAtsBranch(), ArtifactId.valueOf((Long)teamId), AtsRelationTypes.AgileTeamToSprint_Sprint, (ArtifactTypeId)AtsArtifactTypes.AgileSprint);
        ArrayList<ArtifactToken> sprints = new ArrayList<ArtifactToken>();
        if (!relatedSprints.isEmpty()) {
            Collection<ArtifactToken> inWorkSprints = TokenSearchOperations.getArtifactTokensMatchingAttrValue((BranchId)this.atsApi.getAtsBranch(), relatedSprints, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, StateType.Working.name(), this.orcsApi, this.jdbcService);
            for (ArtifactToken sprintArt : inWorkSprints) {
                sprints.add(sprintArt);
            }
        }
        return sprints;
    }

    public JaxAgileSprint getSprint(long teamId, long sprintId) {
        if (teamId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        if (sprintId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "sprintId is not valid", new Object[0]);
        }
        for (IAgileSprint sprint : this.atsApi.getAgileService().getSprintsForTeam(teamId)) {
            if (!sprint.getId().equals(sprintId)) continue;
            return this.toJaxSprint(sprint);
        }
        return null;
    }

    @GET
    @Path(value="team/{teamId}/sprintcurrent")
    @Produces(value={"application/json"})
    public JaxAgileSprint getSprintCurrent(@PathParam(value="teamId") long teamId) {
        if (teamId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        for (IAgileSprint sprint : this.atsApi.getAgileService().getSprintsForTeam(teamId)) {
            if (!sprint.isActive()) continue;
            return this.toJaxSprint(sprint);
        }
        return null;
    }

    public String getSprintSummary(long teamId, long sprintId) {
        try {
            String report = this.getBestOrStored(sprintId, AgileReportType.Summary, this.uriInfo);
            if (Strings.isValid((String)report)) {
                return report;
            }
            ArtifactToken team = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
            IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(sprintId);
            SprintPageBuilder page = new SprintPageBuilder((ArtifactReadable)team, (ArtifactReadable)sprint.getStoreObject(), this.atsApi);
            PageCreator appPage = PageFactory.newPageCreator((IResourceRegistry)this.resourceRegistry, (String[])new String[0]);
            String result = page.generatePage(appPage, (ResourceToken)new ClassBasedResourceToken("sprintTemplate.html", SprintPageBuilder.class));
            return result;
        }
        catch (Exception ex) {
            return AHTML.simplePage((String)Lib.exceptionToString((Exception)ex).replaceAll("\n", "<br/>"));
        }
    }

    private String getBestOrStored(long sprintId, AgileReportType agileReportType, UriInfo uriInfo) {
        MultivaluedMap qp;
        List values;
        boolean best = false;
        boolean stored = false;
        if (uriInfo != null && (values = (List)(qp = uriInfo.getQueryParameters(true)).get((Object)"type")) != null && !values.isEmpty()) {
            best = ((String)values.iterator().next()).equals("best");
            stored = ((String)values.iterator().next()).equals("stored");
        }
        IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(sprintId);
        Conditions.assertNotNull((Object)sprint, (String)"Invalid Sprint %s", (Object[])new Object[]{sprintId});
        if (best && sprint.isCompletedOrCancelled() || stored) {
            ArtifactToken rptArt = this.atsApi.getRelationResolver().getChildNamedOrNull((IAtsObject)sprint, agileReportType.name());
            if (rptArt != null) {
                return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)rptArt, (AttributeTypeToken)CoreAttributeTypes.NativeContent, null);
            }
            if (stored) {
                return AHTML.simplePage((String)"Stored Summary Not Found");
            }
        }
        return null;
    }

    public AgileSprintData getSprintData(long teamId, long sprintId) {
        XResultData results = new XResultData();
        AgileSprintData data = SprintUtil.getAgileSprintData((AtsApi)this.atsApi, (long)teamId, (long)sprintId, (XResultData)results);
        data.validate();
        return data;
    }

    @POST
    @Path(value="team/{teamId}/sprint/{sprintId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AgileSprintData updateSprint(@PathParam(value="teamId") long teamId, @PathParam(value="sprintId") long sprintId, AgileSprintData sprintData) {
        XResultData results = new XResultData();
        AgileSprintData data = SprintUtil.updateAgileSprintData((AtsApi)this.atsApi, (long)teamId, (long)sprintId, (AgileSprintData)sprintData, (XResultData)results);
        return data;
    }

    public SprintConfigurations getSprintConfig(long teamId, long sprintId) {
        SprintConfigOperations ops = new SprintConfigOperations(this.atsApi);
        return ops.get(ArtifactId.valueOf((Long)sprintId));
    }

    @POST
    @Path(value="team/{teamId}/sprint/{sprintId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SprintConfigurations updateSprintConfig(@PathParam(value="teamId") long teamId, @PathParam(value="sprintId") long sprintId, SprintConfigurations sprintConfig) {
        SprintConfigOperations ops = new SprintConfigOperations(this.atsApi);
        ops.update(sprintConfig);
        return sprintConfig;
    }

    public String getSprintDataTable(long teamId, long sprintId) {
        try {
            String report = this.getBestOrStored(sprintId, AgileReportType.Data_Table, this.uriInfo);
            if (Strings.isValid((String)report)) {
                return report;
            }
            AgileSprintData sprintData = SprintUtil.getAgileSprintData((AtsApi)this.atsApi, (long)teamId, (long)sprintId, (XResultData)new XResultData());
            XResultData results = sprintData.validate();
            if (results.isErrors()) {
                throw new OseeArgumentException(results.toString(), new Object[0]);
            }
            SprintDataTableBuilder pageBuilder = new SprintDataTableBuilder(sprintData);
            String html = pageBuilder.getHtml();
            return html;
        }
        catch (Exception ex) {
            return AHTML.simplePage((String)Lib.exceptionToString((Exception)ex).replaceAll("\n", "<br/>"));
        }
    }

    public ILineChart getSprintBurndownChartData(long teamId, long sprintId) {
        SprintBurndownOperations op = new SprintBurndownOperations(this.atsApi);
        return op.getChartData(teamId, sprintId);
    }

    public String getSprintBurndownChartUi(long teamId, long sprintId) {
        String report = this.getBestOrStored(sprintId, AgileReportType.Burn_Down, this.uriInfo);
        if (Strings.isValid((String)report)) {
            return report;
        }
        SprintBurndownOperations op = new SprintBurndownOperations(this.atsApi);
        return op.getReportHtml(teamId, sprintId);
    }

    public XResultData storeSprintReports(long teamId, long sprintId) {
        return this.atsApi.getAgileService().storeSprintReports(teamId, sprintId);
    }

    public String getSprintBurnupChartUi(long teamId, long sprintId) {
        String report = this.getBestOrStored(sprintId, AgileReportType.Burn_Up, this.uriInfo);
        if (Strings.isValid((String)report)) {
            return report;
        }
        SprintBurnupOperations op = new SprintBurnupOperations(this.atsApi);
        return op.getReportHtml(teamId, sprintId);
    }

    public LineChart getSprintBurnupChartData(long teamId, long sprintId) {
        SprintBurnupOperations op = new SprintBurnupOperations(this.atsApi);
        return op.getChartData(teamId, sprintId);
    }

    public Response deleteSprint(long teamId, long sprintId) {
        this.atsApi.getAgileService().deleteSprint(sprintId);
        return Response.ok().build();
    }

    public List<AgileItem> getSprintItems(long teamId, long sprintId) {
        LinkedList<AgileItem> items = new LinkedList<AgileItem>();
        IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(sprintId);
        IAgileTeam team = this.atsApi.getAgileService().getAgileTeam(teamId);
        IAgileBacklog backlog = this.atsApi.getAgileService().getAgileBacklog(team);
        if (sprint != null) {
            int x = 1;
            for (IAgileItem aItem : this.atsApi.getAgileService().getItems(sprint)) {
                AgileItem item = SprintUtil.getAgileItem((IAgileItem)aItem, (AtsApi)this.atsApi);
                item.setOrder(x++);
                item.setSprint(sprint.getName());
                if (backlog != null) {
                    item.setBacklog(backlog.getName());
                }
                items.add(item);
            }
        }
        return items;
    }

    public JaxKbSprint getSprintItemsForKb(long teamId, long sprintId) {
        return new KanbanOperations(this.atsApi, teamId, sprintId, KanbanRowType.BY_ASSIGNEE).getSprintItemsForKb();
    }

    public JaxKbSprint getSprintItemsForKb(AtsApi atsApi, long teamId, long sprintId) {
        KanbanRowType rowType = KanbanRowType.BY_ASSIGNEE;
        MultivaluedMap qp = this.uriInfo.getQueryParameters(true);
        List values = (List)qp.get((Object)"rowType");
        if (Conditions.hasValues((Collection)values)) {
            try {
                rowType = KanbanRowType.valueOf((String)((String)values.iterator().next()));
            }
            catch (Exception exception) {}
        }
        return new KanbanOperations(atsApi, teamId, sprintId, rowType).getSprintItemsForKb();
    }

    public JaxKbSprint getSprintItemsForKbByStory(long teamId, long sprintId) {
        return new KanbanOperations(this.atsApi, teamId, sprintId, KanbanRowType.BY_STORY).getSprintItemsForKb();
    }

    public Response createBacklog(long teamId, JaxNewAgileBacklog newBacklog) {
        if (!Strings.isValid((String)newBacklog.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        if (newBacklog.getTeamId() <= 0L) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "teamId is not valid", new Object[0]);
        }
        IAgileBacklog backlog = null;
        if (!Strings.isValid((String)newBacklog.getName())) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "name is not valid", new Object[0]);
        }
        Long id = newBacklog.getId();
        if (id == null || id <= 0L) {
            id = Lib.generateArtifactIdAsInt();
        }
        ArtifactToken teamArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(newBacklog.getTeamId()));
        if (!this.atsApi.getRelationResolver().getRelated((ArtifactId)teamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog).isEmpty()) {
            throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, "Backlog already set for team %s", new Object[]{teamArt.toStringWithId()});
        }
        backlog = this.atsApi.getAgileService().createAgileBacklog(newBacklog.getTeamId(), newBacklog.getName(), id);
        JaxAgileBacklog created = this.toJaxBacklog(backlog);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(backlog.getTeamId())).path("backlog").build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    public Response updateBacklog(long teamId, JaxAgileBacklog newBacklog) {
        IAgileBacklog backlog = this.atsApi.getAgileService().updateAgileBacklog(newBacklog);
        JaxAgileBacklog created = this.toJaxBacklog(backlog);
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path("teams").path(String.valueOf(created.getTeamId())).build(new Object[0]);
        return Response.created((URI)location).entity((Object)created).build();
    }

    public JaxAgileBacklog getBacklog(long teamId) {
        if (teamId <= 0L) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        IAgileBacklog backlog = this.atsApi.getAgileService().getBacklogForTeam(teamId);
        if (backlog != null) {
            return this.toJaxBacklog(backlog);
        }
        return null;
    }

    public ArtifactToken getBacklogToken(ArtifactId teamId) {
        if (teamId.isInvalid()) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "teamId is not valid", new Object[0]);
        }
        return this.atsApi.getQueryService().getArtifactToken(teamId);
    }

    public List<AgileItem> getBacklogItems(long teamId) {
        LinkedList<AgileItem> items = new LinkedList<AgileItem>();
        IAgileTeam team = this.atsApi.getAgileService().getAgileTeam(teamId);
        IAgileBacklog backlog = this.atsApi.getAgileService().getAgileBacklog(team);
        if (backlog != null) {
            int x = 1;
            for (IAgileItem aItem : this.atsApi.getAgileService().getItems(backlog)) {
                AgileItem item = SprintUtil.getAgileItem((IAgileItem)aItem, (AtsApi)this.atsApi);
                item.setOrder(x++);
                IAgileSprint sprint = this.atsApi.getAgileService().getSprint(aItem);
                if (sprint != null) {
                    item.setSprint(sprint.getName());
                }
                item.setBacklog(backlog.getName());
                items.add(item);
            }
        }
        return items;
    }

    private JaxAgileBacklog toJaxBacklog(IAgileBacklog backlog) {
        JaxAgileBacklog result = new JaxAgileBacklog();
        result.setActive(backlog.isActive());
        result.setActive(backlog.isActive());
        result.setName(backlog.getName());
        result.setId(backlog.getId());
        result.setTeamId(backlog.getTeamId());
        return result;
    }

    public AgileWriterResult updateAgileItem(long itemId, JaxAgileItem newItem) {
        if (newItem.getIds().isEmpty()) {
            throw new OseeWebApplicationException(Response.Status.NOT_FOUND, "itemId is not valid", new Object[0]);
        }
        AgileWriterResult result = this.atsApi.getAgileService().updateAgileItem(newItem);
        JaxAgileItem item = new JaxAgileItem();
        item.getIds().addAll(result.getJaxAgileItem().getIds());
        item.getFeatures().addAll(result.getJaxAgileItem().getFeatures());
        item.setSprintId(result.getJaxAgileItem().getSprintId());
        return result;
    }

    public AgileWriterResult updateItems(JaxAgileItem newItem) {
        AgileWriterResult result = this.atsApi.getAgileService().updateAgileItem(newItem);
        return result;
    }

    public JaxAtsObjects getSprintItemsAsJax(long teamId, long sprintId) {
        ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId));
        JaxAtsObjects objs = new JaxAtsObjects();
        for (IAtsWorkItem workItem : this.atsApi.getWorkItemService().getWorkItems(this.atsApi.getRelationResolver().getRelated((ArtifactId)sprintArt, AtsRelationTypes.AgileSprintToItem_AtsItem))) {
            objs.getAtsObjects().add(JaxAtsObjects.create((IAtsObject)workItem));
        }
        return objs;
    }

    public Collection<IAtsWorkItem> getSprintWorkItems(long teamId, long sprintId) {
        ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId));
        return this.atsApi.getWorkItemService().getWorkItems(this.atsApi.getRelationResolver().getRelated((ArtifactId)sprintArt, AtsRelationTypes.AgileSprintToItem_AtsItem));
    }

    public Response getSprintItemsUI(long teamId, long sprintId) {
        ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId));
        sprintArt = (ArtifactToken)Conditions.getNotNull((Object)sprintArt, (String)"Sprint not found with id %s", (Object[])new Object[]{sprintId});
        Collection<IAtsWorkItem> myWorldItems = this.getSprintWorkItems(teamId, sprintId);
        CustomizeData custData = this.getDefaultAgileCustData();
        Conditions.assertNotNull((Object)custData, (String)"Can't retrieve default customization", (Object[])new Object[0]);
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApi, "Sprint - " + sprintArt.getName(), custData, myWorldItems);
        return Response.ok().entity((Object)table).build();
    }

    private CustomizeData getDefaultAgileCustData() {
        CustomizeData result = null;
        try {
            String custDataStr = OseeInf.getResourceContents((String)"atsConfig/DefaultAgileCustomization.json", this.getClass());
            if (Strings.isValid((String)custDataStr)) {
                result = (CustomizeData)this.orcsApi.jaxRsApi().readValue(custDataStr, CustomizeData.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Response getSprintItemsUICustomized(long teamId, long sprintId, String customizeGuid) {
        ArtifactToken sprintArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId));
        sprintArt = (ArtifactToken)Conditions.getNotNull((Object)sprintArt, (String)"Sprint not found with id %s", (Object[])new Object[]{sprintId});
        Collection<IAtsWorkItem> myWorldItems = this.getSprintWorkItems(teamId, sprintId);
        CustomizeData custData = this.atsApi.getStoreService().getCustomizationByGuid(customizeGuid);
        Conditions.assertNotNull((Object)custData, (String)"Can't retrieve customization with id %s", (Object[])new Object[]{customizeGuid});
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApi, "Sprint - " + sprintArt.getName(), custData, myWorldItems);
        return Response.ok().entity((Object)table).build();
    }

    @PUT
    @Path(value="item/{itemId}/feature")
    public Response addFeatureGroup(@PathParam(value="itemId") long itemId, String featureGroupName) {
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(itemId));
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsApi.getWorkItemService().getAgileItem(itemArt);
        boolean found = false;
        for (IAgileFeatureGroup feature : this.atsApi.getAgileService().getFeatureGroups(item)) {
            if (!feature.getName().equals(featureGroupName)) continue;
            found = true;
            break;
        }
        if (!found) {
            IAgileTeam team = this.atsApi.getAgileService().getAgileTeam(item);
            for (ArtifactReadable featureArt : ((ArtifactReadable)team.getStoreObject()).getRelated(AtsRelationTypes.AgileTeamToFeatureGroup_AgileFeatureGroup)) {
                if (!featureArt.getName().equals(featureGroupName)) continue;
                IAtsChangeSet changes = this.atsApi.createChangeSet("Add Feature Group to WorkItem", AtsCoreUsers.SYSTEM_USER);
                changes.relate((Object)featureArt, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)item);
                changes.execute();
                return Response.ok().build();
            }
        }
        return Response.notModified().build();
    }

    @PUT
    @Path(value="item/{itemId}/unplanned")
    public Response setUnPlanned(@PathParam(value="itemId") long itemId, boolean unPlanned) {
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(itemId));
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsApi.getWorkItemService().getAgileItem(itemArt);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Agile UnPlanned", AtsCoreUsers.SYSTEM_USER);
        changes.setSoleAttributeValue((IAtsObject)item, (AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)unPlanned);
        changes.execute();
        return Response.ok().build();
    }

    @PUT
    @Path(value="item/{itemId}/points")
    public Response setPoints(@PathParam(value="itemId") long itemId, String points) {
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(itemId));
        Conditions.assertNotNull((Object)itemArt, (String)"Work Item not found with id %s", (Object[])new Object[]{itemId});
        IAgileItem item = this.atsApi.getWorkItemService().getAgileItem(itemArt);
        IAgileTeam team = this.atsApi.getAgileService().getAgileTeam(item);
        AttributeTypeToken agileTeamPointsAttributeType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(team);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Points", AtsCoreUsers.SYSTEM_USER);
        changes.setSoleAttributeValue((IAtsWorkItem)item, agileTeamPointsAttributeType, points);
        changes.execute();
        return Response.ok().build();
    }

    public String getBurndownBest(long teamId) {
        try {
            IAgileSprint sprint = this.getSingleOrFirstSprint(teamId);
            if (sprint != null) {
                return this.getSprintBurndownChartUi(teamId, sprint.getId());
            }
        }
        catch (Exception ex) {
            return Lib.exceptionToString((Exception)ex);
        }
        return AHTML.simplePage((String)("No In-Work Sprint found for team " + teamId));
    }

    private IAgileSprint getSingleOrFirstSprint(long teamId) {
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        if (artifact != null) {
            for (ArtifactToken sprintArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
                IAgileSprint sprint = this.atsApi.getWorkItemService().getAgileSprint(sprintArt);
                if (!sprint.isInWork()) continue;
                return sprint;
            }
        }
        return null;
    }
}

