/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.transform;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.xml.SaxTransformer;
import org.eclipse.osee.orcs.db.internal.exchange.ExchangeUtil;
import org.eclipse.osee.orcs.db.internal.exchange.IOseeExchangeDataProvider;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;
import org.xml.sax.ContentHandler;

public final class ExchangeDataProcessor {
    private final IOseeExchangeDataProvider dataProvider;

    public IOseeExchangeDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public ExchangeDataProcessor(IOseeExchangeDataProvider exportDataProvider) {
        this.dataProvider = exportDataProvider;
    }

    public void transform(String fileName, SaxTransformer transformer) {
        this.transform(this.dataProvider.getFile(fileName), transformer);
    }

    public void transform(ExportItem exportItem, SaxTransformer transformer) {
        this.transform(this.dataProvider.getFile(exportItem), transformer);
    }

    private void transform(File targetFile, SaxTransformer transformer) {
        File tempFile = new File(Lib.changeExtension((String)targetFile.getPath(), (String)"temp"));
        Writer fileWriter = null;
        try {
            try {
                fileWriter = this.startTransform(targetFile, tempFile, transformer);
                ExchangeUtil.readExchange(tempFile, (ContentHandler)transformer);
                tempFile.delete();
            }
            catch (Exception ex) {
                this.renameExportItem(tempFile, targetFile);
                OseeCoreException.wrapAndThrow((Throwable)ex);
                try {
                    try {
                        transformer.finish();
                    }
                    catch (Exception ex2) {
                        OseeCoreException.wrapAndThrow((Throwable)ex2);
                        Lib.close((AutoCloseable)fileWriter);
                    }
                }
                finally {
                    Lib.close((AutoCloseable)fileWriter);
                }
            }
        }
        finally {
            block20: {
                try {
                    try {
                        transformer.finish();
                    }
                    catch (Exception ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                        Lib.close((AutoCloseable)fileWriter);
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close((AutoCloseable)fileWriter);
                    throw throwable;
                }
                Lib.close((AutoCloseable)fileWriter);
            }
        }
    }

    public Writer startTransform(File targetFile, File tempFile, SaxTransformer transformer) throws XMLStreamException, IOException {
        this.renameExportItem(targetFile, tempFile);
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(targetFile));
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(fileWriter);
        transformer.setWriter(xmlWriter);
        return fileWriter;
    }

    public void deleteExportItem(String fileName) {
        this.dataProvider.getFile(fileName).delete();
    }

    public void renameExportItem(String originalFileName, String newFileName) {
        this.renameExportItem(this.dataProvider.getFile(originalFileName), this.dataProvider.getFile(newFileName));
    }

    private void renameExportItem(File original, File destination) {
        boolean wasSuccessful = original.renameTo(destination);
        if (!wasSuccessful) {
            throw new OseeStateException("Error renaming [%s] to [%s]", new Object[]{original, destination});
        }
    }

    public void copyExportItem(String sourceFileName, String destinationFileName) {
        File source = this.dataProvider.getFile(sourceFileName);
        File destination = this.dataProvider.getFile(destinationFileName);
        try {
            Lib.copyFile((File)source, (File)destination);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void parse(String fileName, ContentHandler handler) {
        ExchangeUtil.readExchange(this.dataProvider.getFile(fileName), handler);
    }

    public void parse(IExportItem exportItem, ContentHandler handler) {
        try {
            ExchangeUtil.readExchange(this.dataProvider.getFile(exportItem), handler);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void transform(ExportItem exportItem, Rule rule) {
        try {
            rule.process(this.dataProvider.getFile(exportItem));
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void cleanUp() {
        ExchangeUtil.cleanUpTempExchangeFile(this.dataProvider.getExchangeBasePath(), this.dataProvider.getLogger(), this.dataProvider.getExportedDataRoot(), this.dataProvider.wasZipExtractionRequired());
    }
}

