/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;

public class AddSyntheticArtifactChangeData {
    private final List<ChangeItem> changeItems;
    private final JdbcClient jdbcClient;
    private final BranchId branch;
    private final OrcsTokenService tokenService;
    private static final String ART_TYPE_ID_QUERY = "select art.art_id, art.art_type_id from osee_artifact art, osee_txs txs where txs.BRANCH_ID = ? and art.GAMMA_ID = txs.GAMMA_ID and txs.tx_current = 1 and art_id in (%s)";

    public AddSyntheticArtifactChangeData(List<ChangeItem> changeItems, JdbcClient jdbcClient, BranchId branch, OrcsTokenService tokenService) {
        this.changeItems = changeItems;
        this.jdbcClient = jdbcClient;
        this.branch = branch;
        this.tokenService = tokenService;
    }

    public List<ChangeItem> doWork() {
        HashMap<ArtifactId, ChangeItem> artifactChanges = new HashMap<ArtifactId, ChangeItem>();
        for (ChangeItem item : this.changeItems) {
            if (!item.getChangeType().isArtifactChange()) continue;
            artifactChanges.put(item.getArtId(), item);
        }
        ArrayList<ChangeItem> attrItems = new ArrayList<ChangeItem>();
        HashMap<ArtifactId, ChangeItem> syntheticArtifactChanges = new HashMap<ArtifactId, ChangeItem>();
        HashSet<Long> artIds = new HashSet<Long>();
        for (ChangeItem item : this.changeItems) {
            ChangeItem attributeChange;
            ArtifactId artIdToCheck;
            ChangeItem artifactChange;
            artIds.add(item.getArtId().getId());
            if (!item.getChangeType().isAttributeChange() || (artifactChange = (ChangeItem)artifactChanges.get(artIdToCheck = (attributeChange = item).getArtId())) != null) continue;
            artifactChange = (ChangeItem)syntheticArtifactChanges.get(artIdToCheck);
            if (artifactChange == null) {
                artifactChange = ChangeItemUtil.newArtifactChange((ArtifactId)artIdToCheck, (ArtifactTypeId)ArtifactTypeId.SENTINEL, (GammaId)GammaId.SENTINEL, null, null);
                syntheticArtifactChanges.put(artIdToCheck, artifactChange);
                artifactChange.setSynthetic(true);
            }
            attrItems.add(attributeChange);
            this.updateArtifactChangeItem(artifactChange, attributeChange);
        }
        Map<Long, Long> artIdToArtTypeid = this.getArtIdToArtTypeIdMap(this.branch, artIds);
        for (ChangeItem change : syntheticArtifactChanges.values()) {
            ArtifactTypeToken artifactTypeToken = ArtifactTypeToken.SENTINEL;
            if (!AddSyntheticArtifactChangeData.isAllowableChange(change.getIgnoreType())) continue;
            this.changeItems.add(change);
            if (!change.getChangeType().isArtifactChange()) continue;
            if (artIdToArtTypeid.containsKey(change.getArtId().getId())) {
                artifactTypeToken = this.tokenService.getArtifactType(artIdToArtTypeid.get(change.getArtId().getId()));
            }
            change.setItemTypeId((Id)artifactTypeToken);
        }
        return this.changeItems;
    }

    private Map<Long, Long> getArtIdToArtTypeIdMap(BranchId branchId, Set<Long> artIds) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        LinkedList<Integer> artIdsAsInt = new LinkedList<Integer>();
        for (Long id : artIds) {
            artIdsAsInt.add(id.intValue());
        }
        if (!artIds.isEmpty()) {
            for (Collection ids : Collections.subDivide(artIdsAsInt, (int)999)) {
                String query = String.format(ART_TYPE_ID_QUERY, Collections.toString((String)",", (Iterable)ids));
                this.jdbcClient.runQuery(stmt -> {
                    Long l = map.put(stmt.getLong("art_id"), stmt.getLong("art_type_id"));
                }, query, new Object[]{branchId.getId()});
            }
        }
        return map;
    }

    private void updateArtifactChangeItem(ChangeItem artifact, ChangeItem attribute) {
        try {
            if (attribute.getBaselineVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getBaselineVersion(), (ChangeVersion)artifact.getBaselineVersion());
            }
            if (attribute.getCurrentVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getCurrentVersion(), (ChangeVersion)artifact.getCurrentVersion());
            }
            if (attribute.getDestinationVersion().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getDestinationVersion(), (ChangeVersion)artifact.getDestinationVersion());
            }
            if (attribute.getNetChange().isValid()) {
                ChangeItemUtil.copy((ChangeVersion)attribute.getNetChange(), (ChangeVersion)artifact.getNetChange());
                artifact.getNetChange().setModType(ModificationType.MODIFIED);
            }
            if (artifact.getIgnoreType().isInvalid() || !AddSyntheticArtifactChangeData.isAllowableChange(artifact.getIgnoreType())) {
                ChangeItemUtil.checkAndSetIgnoreCase((ChangeItem)artifact);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isAllowableChange(ChangeIgnoreType ignoreType) {
        return ignoreType.isNone() || ignoreType.isResurrected() || ignoreType.isDeletedOnDestAndNotResurrected() || ignoreType.isDeletedOnDestination();
    }
}

