/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal.validator;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.account.admin.internal.validator.AbstractValidator;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractConfigurableValidator
extends AbstractValidator {
    private Pattern customPattern;

    public void setCustomPattern(Pattern customPattern) {
        this.customPattern = customPattern;
    }

    public boolean hasCustomPattern() {
        return this.customPattern != null;
    }

    public Pattern getCustomPattern() {
        return this.customPattern;
    }

    @Override
    public boolean isValid(String value) {
        boolean result = Strings.isValid((String)value);
        if (result && this.hasCustomPattern()) {
            result = this.isValid(this.getCustomPattern(), value);
        }
        return result;
    }

    protected boolean isValid(Pattern pattern, String value) {
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    @Override
    public void validate(String value) {
        super.validate(value);
        Conditions.checkExpressionFailOnTrue((boolean)this.exists(value), (String)"Invalid [%s] - [%s] is already in use", (Object[])new Object[]{this.getName(), value});
    }

    public abstract String getPatternFromConfig(Map<String, Object> var1);

    public abstract boolean exists(String var1);

    protected String get(Map<String, Object> props, String key, String defaultValue) {
        Object object;
        String toReturn = defaultValue;
        Object object2 = object = props != null ? props.get(key) : null;
        if (object != null) {
            toReturn = String.valueOf(object);
        }
        return toReturn;
    }
}

