/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import java.io.File;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class OseeServerProperties {
    private static final String OSGI_PORT_PROPERTY = "org.osgi.service.http.port";
    private static final String OSGI_SECURE_PORT_PROPERTY = "org.osgi.service.http.port.secure";
    private static final String OSEE_AUTHENTICATION_PROTOCOL = "osee.authentication.protocol";
    private static boolean wasBinaryDataChecked = false;

    private OseeServerProperties() {
    }

    private static String internalGetOseeApplicationServerData() {
        String userHome;
        String toReturn = System.getProperty("osee.application.server.data");
        if (toReturn == null && Strings.isValid((String)(userHome = System.getProperty("user.home")))) {
            toReturn = userHome;
        }
        return toReturn;
    }

    public static String getOseeApplicationServerData(Log logger) {
        String toReturn = OseeServerProperties.internalGetOseeApplicationServerData();
        if (!wasBinaryDataChecked) {
            File file = new File(toReturn);
            if (logger != null) {
                if (file.exists()) {
                    logger.info("Application Server Data: [%s]", new Object[]{toReturn});
                } else {
                    logger.warn("Application Server Data: [%s] does not exist and will be created", new Object[]{toReturn});
                }
            }
            wasBinaryDataChecked = true;
        }
        return toReturn;
    }

    public static int getOseeApplicationServerPort() {
        int toReturn = Integer.valueOf(System.getProperty(OSGI_SECURE_PORT_PROPERTY, "-1"));
        if (toReturn == -1) {
            toReturn = Integer.valueOf(System.getProperty(OSGI_PORT_PROPERTY, "-1"));
        }
        return toReturn;
    }

    public static String getOseeApplicationServerScheme() {
        String toReturn = "https";
        if (Integer.valueOf(System.getProperty(OSGI_SECURE_PORT_PROPERTY, "-1")) == -1) {
            toReturn = "http";
        }
        return toReturn;
    }

    public static String getOseeConnectionInfoUri() {
        return OseeProperties.getOseeConnectionInfoUri();
    }

    public static String getAuthenticationProtocol() {
        return System.getProperty(OSEE_AUTHENTICATION_PROTOCOL, "");
    }

    public static void setAuthenticationProtocol(String protocol) {
        System.setProperty(OSEE_AUTHENTICATION_PROTOCOL, protocol);
    }
}

