/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsPerformance;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.HasStatistics;
import org.eclipse.osee.orcs.core.internal.indexer.IndexerModule;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;
import org.eclipse.osee.orcs.statistics.QueryStatistics;

public class OrcsPerformanceImpl
implements OrcsPerformance {
    private final QueryModule queryModule;
    private final IndexerModule indexerModule;
    private final OrcsSession session;

    public OrcsPerformanceImpl(Log logger, OrcsSession session, QueryModule queryModule, IndexerModule indexerModule) {
        this.session = session;
        this.queryModule = queryModule;
        this.indexerModule = indexerModule;
    }

    public HasStatistics<?> getStatistics() {
        return this.queryModule;
    }

    public QueryStatistics getQueryStatistics() {
        return this.queryModule.getStatistics(this.session);
    }

    public IndexerStatistics getIndexerStatistics() {
        return this.indexerModule.getStatistics(this.session);
    }

    public void clearQueryStatistics() {
        this.queryModule.clearStatistics(this.session);
    }

    public void clearIndexerStatistics() {
        this.indexerModule.clearStatistics(this.session);
    }
}

