/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.HeaderParam;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsProductLineEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ActionOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public final class AtsProductLineEndpointImpl
implements AtsProductLineEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    @HeaderParam(value="osee.account.id")
    private UserId accountId;

    public AtsProductLineEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public List<BranchToken> getBranches(String branchQueryType) {
        ArrayList<BranchToken> pleBranchList = new ArrayList<BranchToken>();
        if (branchQueryType.equals("baseline")) {
            for (Branch branch : ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList()) {
                if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
                pleBranchList.add((BranchToken)branch);
            }
        }
        if (branchQueryType.equals("working")) {
            ArrayList<String> arbs = new ArrayList<String>();
            for (ArtifactId arbIds : this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andAttributeIs((AttributeTypeId)AtsAttributeTypes.WorkType, "ARB").asArtifactIds()) {
                arbs.add(arbIds.getIdString());
            }
            for (ArtifactId artifactId : this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).and((AttributeTypeId)AtsAttributeTypes.ActionableItemReference, arbs, new QueryOption[0]).asArtifactIds()) {
                pleBranchList.addAll(((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).andAssociatedArtId(artifactId)).getResults().getList());
            }
        }
        Collections.sort(pleBranchList);
        return pleBranchList;
    }

    public XResultData checkPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        ActionOperations ops = new ActionOperations(null, workItem, this.atsApi, this.orcsApi);
        Attribute approval = ops.getActionAttributeValues((AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, workItem);
        if (approval.getValues().isEmpty()) {
            rd.error("Working branch has not yet been approved by PLARB");
        }
        return rd;
    }

    public XResultData setPlarbApproval(String id) {
        XResultData rd = new XResultData();
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Plarb approval user");
        Date resultDate = new Date(System.currentTimeMillis());
        if (this.accountId == null) {
            rd.error("Account Id not passed properly.  See Admin for help.");
        }
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedBy, (Object)this.accountId);
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ProductLineApprovedDate, (Object)resultDate);
        changes.execute();
        return rd;
    }
}

