/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

class RecoveredPackageBinding
implements IPackageBinding {
    private static final String[] NO_NAME_COMPONENTS = CharOperation.NO_STRINGS;
    private static final String UNNAMED = Util.EMPTY_STRING;
    private static final char PACKAGE_NAME_SEPARATOR = '.';
    private PackageBinding binding;
    private BindingResolver resolver;
    private String name = null;
    private String[] components = null;

    RecoveredPackageBinding(PackageBinding binding, BindingResolver resolver) {
        this.binding = binding;
        this.resolver = resolver;
    }

    @Override
    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public IJavaElement getJavaElement() {
        return null;
    }

    @Override
    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Recovered#");
        buffer.append(this.binding.computeUniqueKey());
        return buffer.toString();
    }

    @Override
    public boolean isEqualTo(IBinding other) {
        if (!other.isRecovered() || other.getKind() != 1) {
            return false;
        }
        return this.getKey().equals(other.getKey());
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.computeNameAndComponents();
        }
        return this.name;
    }

    @Override
    public boolean isUnnamed() {
        return false;
    }

    @Override
    public String[] getNameComponents() {
        if (this.components == null) {
            this.computeNameAndComponents();
        }
        return this.components;
    }

    @Override
    public IModuleBinding getModule() {
        ModuleBinding moduleBinding = this.binding.enclosingModule;
        return moduleBinding != null ? this.resolver.getModuleBinding(moduleBinding) : null;
    }

    private void computeNameAndComponents() {
        char[][] compoundName = this.binding.compoundName;
        if (compoundName == CharOperation.NO_CHAR_CHAR || compoundName == null) {
            this.name = UNNAMED;
            this.components = NO_NAME_COMPONENTS;
        } else {
            int length = compoundName.length;
            this.components = new String[length];
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < length - 1) {
                this.components[i] = new String(compoundName[i]);
                buffer.append(compoundName[i]).append('.');
                ++i;
            }
            this.components[length - 1] = new String(compoundName[length - 1]);
            buffer.append(compoundName[length - 1]);
            this.name = buffer.toString();
        }
    }
}

