/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactType;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class ArtifactTypeSqlHandler
extends SqlHandler<CriteriaArtifactType> {
    private CriteriaArtifactType criteria;
    private String jIdAlias;
    private AbstractJoinQuery joinQuery;
    private String artAlias;
    private String txsAlias;

    @Override
    public void setData(CriteriaArtifactType criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.getTypes().size() > 1) {
            this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        this.txsAlias = writer.getMainTableAlias(OseeDb.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        Collection types = this.criteria.getTypes();
        if (types.size() > 1) {
            this.joinQuery = writer.writeJoin(types);
            writer.writeEqualsParameterAnd(this.jIdAlias, "query_id", this.joinQuery.getQueryId());
            writer.writeEquals(this.jIdAlias, "id", this.artAlias, "art_type_id");
        } else {
            writer.writeEqualsParameter(this.artAlias, "art_type_id", types.iterator().next());
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_TYPE.ordinal();
    }
}

