/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.filters.OAuthRequestFilter;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;

@Provider
public class JaxRsOAuthResourceServerFilter
implements ContainerRequestFilter {
    private final OAuthRequestFilter delegate;

    private JaxRsOAuthResourceServerFilter(OAuthRequestFilter delegate) {
        this.delegate = delegate;
    }

    public void setAudienceIsEndpointAddress(boolean audienceIsEndpointAddress) {
        this.delegate.setAudienceIsEndpointAddress(audienceIsEndpointAddress);
    }

    public void setCheckFormData(boolean checkFormData) {
        this.delegate.setCheckFormData(checkFormData);
    }

    public void setRealm(String realm) {
        this.delegate.setRealm(realm);
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.delegate.setUseUserSubject(useUserSubject);
    }

    public void setAudiences(List<String> audiences) {
        this.delegate.setAudience(audiences.toString());
    }

    public void filter(ContainerRequestContext context) {
        this.delegate.filter(context);
    }

    public static Builder newBuilder(JaxRsApi jaxRsApi) {
        return new Builder(jaxRsApi);
    }

    /* synthetic */ JaxRsOAuthResourceServerFilter(OAuthRequestFilter oAuthRequestFilter, JaxRsOAuthResourceServerFilter jaxRsOAuthResourceServerFilter) {
        this(oAuthRequestFilter);
    }

    public static class Builder {
        public static final long MAX_TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = 86400000L;
        private final JaxRsApi jaxRsApi;
        private String resourceServerKey;
        private String resourceServerSecret;
        private String validationServerUri;

        public Builder(JaxRsApi jaxRsApi) {
            this.jaxRsApi = jaxRsApi;
        }

        public JaxRsOAuthResourceServerFilter build() {
            ClientAccessTokenValidator validator = Builder.newTokenValidator();
            return this.build(validator);
        }

        public JaxRsOAuthResourceServerFilter build(int cacheMaxSize, long cacheEvictTimeoutMillis) {
            ClientAccessTokenValidator validator = Builder.newCachingTokenValidator(cacheMaxSize, cacheEvictTimeoutMillis);
            return this.build(validator);
        }

        private JaxRsOAuthResourceServerFilter build(ClientAccessTokenValidator validator) {
            validator.setTarget(this.jaxRsApi.newTargetPasswd(this.validationServerUri, this.resourceServerKey, this.resourceServerSecret));
            OAuth2RequestFilter filter = new OAuth2RequestFilter();
            filter.setTokenValidator(validator);
            return new JaxRsOAuthResourceServerFilter(filter, null);
        }

        public Builder serverUri(String validationServerUri) {
            this.validationServerUri = validationServerUri;
            return this;
        }

        public Builder serverKey(String resourceServerKey) {
            this.resourceServerKey = resourceServerKey;
            return this;
        }

        public Builder serverSecret(String resourceServerSecret) {
            this.resourceServerSecret = resourceServerSecret;
            return this;
        }

        private static ClientAccessTokenValidator newTokenValidator() {
            return new ClientAccessTokenValidator(){

                @Override
                public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String accessToken) throws OAuthServiceException {
                    return this.getRemoteTokenValidation(authScheme, accessToken);
                }

                public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String accessToken, MultivaluedMap<String, String> values) throws OAuthServiceException {
                    return null;
                }
            };
        }

        private static ClientAccessTokenValidator newCachingTokenValidator(int cacheMaxSize, long cacheEvictTimeoutMillis) {
            Conditions.checkExpressionFailOnTrue((cacheMaxSize <= 0 ? 1 : 0) != 0, (String)"Token Cache max size must be greater than 0", (Object[])new Object[0]);
            Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis > 86400000L ? 1 : 0) != 0, (String)"Token cache evict timeout exceeds max - [%s]", (Object[])new Object[]{Lib.asTimeString((long)86400000L)});
            Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis <= 0L ? 1 : 0) != 0, (String)"Token cache evict timeout must be greater than 0", (Object[])new Object[0]);
            final Cache cache = CacheBuilder.newBuilder().maximumSize((long)cacheMaxSize).expireAfterWrite(cacheEvictTimeoutMillis, TimeUnit.MILLISECONDS).build();
            return new ClientAccessTokenValidator(){

                @Override
                public AccessTokenValidation validateAccessToken(MessageContext mc, final String authScheme, final String accessToken) throws OAuthServiceException {
                    try {
                        return (AccessTokenValidation)cache.get((Object)accessToken, (Callable)new Callable<AccessTokenValidation>(){

                            @Override
                            public AccessTokenValidation call() {
                                return this.getRemoteTokenValidation(authScheme, accessToken);
                            }
                        });
                    }
                    catch (Exception ex) {
                        throw new OAuthServiceException("Error validating access token", ex.getCause());
                    }
                }

                public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String accessToken, MultivaluedMap<String, String> values) throws OAuthServiceException {
                    return null;
                }
            };
        }

        private static abstract class ClientAccessTokenValidator
        implements AccessTokenValidator {
            private WebTarget target;

            private ClientAccessTokenValidator() {
            }

            public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String accessToken) throws OAuthServiceException {
                return null;
            }

            public List<String> getSupportedAuthorizationSchemes() {
                return Collections.singletonList("*");
            }

            public void setTarget(WebTarget target) {
                this.target = target;
            }

            protected AccessTokenValidation getRemoteTokenValidation(String authScheme, String accessToken) {
                Form form = new Form();
                form.param("authScheme", authScheme);
                form.param("authSchemeData", accessToken);
                return (AccessTokenValidation)this.target.request().post(Entity.form((Form)form), AccessTokenValidation.class);
            }
        }

        private static class OAuth2RequestFilter
        extends OAuthRequestFilter {
            private volatile boolean useUserSubject;

            private OAuth2RequestFilter() {
            }

            public void setUseUserSubject(boolean useUserSubject) {
                super.setUseUserSubject(useUserSubject);
                this.useUserSubject = useUserSubject;
            }

            protected SecurityContext createSecurityContext(HttpServletRequest request, AccessTokenValidation accessTokenV) {
                return OAuthUtil.getSecurityContext(accessTokenV, this.useUserSubject);
            }
        }
    }
}

