/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.data.write;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.layer.Activator;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class TranferableArtifactLoader {
    public static void copyArtifactReadbleToTransferableArtifactWithoutRelations(ArtifactReadable readable, TransferableArtifact transArtifact) throws OseeCoreException {
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            transArtifact.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArtifact.putAttributes("guid", list2);
        transArtifact.setId(readable.getId());
        transArtifact.setArtifactType(readable.getArtifactType().toString());
        transArtifact.setName(readable.getName());
        transArtifact.setBranchGuid(readable.getBranch().getId());
    }

    public static void copyArtifactReadbleToTransferableArtifact(ArtifactReadable readable, ITransferableArtifact ar) throws OseeCoreException {
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            ar.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        ar.putAttributes("guid", list2);
        ar.setId(readable.getId());
        ar.setArtifactType(readable.getArtifactType().toString());
        ar.setName(readable.getName());
        ar.setBranchGuid(readable.getBranch().getId());
        Collection existingRelationTypes = readable.getExistingRelationTypes();
        try {
            for (RelationTypeToken iRelationType : existingRelationTypes) {
                RelationTypeSide createRelationTypeSide1;
                ResultSet relatedArtifacts1;
                RelationTypeSide createRelationTypeSide = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_B);
                ResultSet relatedArtifacts = readable.getRelated(createRelationTypeSide);
                if (relatedArtifacts.size() > 0) {
                    TranferableArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts, createRelationTypeSide, iRelationType, ar);
                }
                if ((relatedArtifacts1 = readable.getRelated(createRelationTypeSide1 = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_A))).size() <= 0) continue;
                TranferableArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts1, createRelationTypeSide1, iRelationType, ar);
            }
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)" Exception while copying relations . Some relation will not be copied ");
        }
    }

    public static void copyProjectArtifactReadbleToTransferableArtifact(ArtifactReadable readable, ITransferableArtifact ar) throws OseeCoreException {
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            ar.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        ar.putAttributes("guid", list2);
        ar.setId(readable.getId());
        ar.setArtifactType(readable.getArtifactType().toString());
        ar.setName(readable.getName());
        ar.setBranchGuid(readable.getBranch().getId());
        Collection existingRelationTypes = readable.getExistingRelationTypes();
        try {
            for (RelationTypeToken iRelationType : existingRelationTypes) {
                RelationTypeSide createRelationTypeSide1;
                ResultSet relatedArtifacts1;
                if (iRelationType.getName().equals("ProjectToTeamWorkFlow")) continue;
                RelationTypeSide createRelationTypeSide = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_B);
                ResultSet relatedArtifacts = readable.getRelated(createRelationTypeSide);
                if (relatedArtifacts.size() > 0) {
                    TranferableArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts, createRelationTypeSide, iRelationType, ar);
                }
                if ((relatedArtifacts1 = readable.getRelated(createRelationTypeSide1 = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_A))).size() <= 0) continue;
                TranferableArtifactLoader.fillRelations((ResultSet<ArtifactReadable>)relatedArtifacts1, createRelationTypeSide1, iRelationType, ar);
            }
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)" Exception while copying relations . Some relation will not be copied ");
        }
    }

    public static void fillRelations(ResultSet<ArtifactReadable> relatedArtifacts, RelationTypeSide side, RelationTypeToken relationType, ITransferableArtifact ar) throws OseeCoreException {
        ArrayList<TransferableArtifact> list1 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : relatedArtifacts) {
            TransferableArtifact art;
            ArtifactReadable user;
            if (artifactReadable.getArtifactType().equals(AtsArtifactTypes.Version)) {
                user = (ArtifactReadable)OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)artifactReadable.getBranch()).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
                art = new TransferableArtifact();
                TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifactDup(user, art);
                list1.add(art);
                continue;
            }
            user = (ArtifactReadable)OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)artifactReadable.getBranch()).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
            art = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(user, (ITransferableArtifact)art);
            list1.add(art);
        }
        ar.putRelations(String.valueOf(relationType.getName()) + "##" + side.getSide().name(), list1);
    }

    public static void copyArtifactReadbleToTransferableArtifactDup(ArtifactReadable readable, TransferableArtifact transArtifact) {
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            transArtifact.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArtifact.putAttributes("guid", list2);
        transArtifact.setId(readable.getId());
        transArtifact.setArtifactType(readable.getArtifactType().toString());
        transArtifact.setName(readable.getName());
        transArtifact.setBranchGuid(readable.getBranch().getId());
        Collection existingRelationTypes = readable.getExistingRelationTypes();
        try {
            for (RelationTypeToken iRelationType : existingRelationTypes) {
                RelationTypeSide createRelationTypeSide1;
                ResultSet relatedArtifacts1;
                RelationTypeSide createRelationTypeSide = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_B);
                ResultSet relatedArtifacts = readable.getRelated(createRelationTypeSide);
                if (relatedArtifacts.size() > 0) {
                    TranferableArtifactLoader.fillRelationsdup((ResultSet<ArtifactReadable>)relatedArtifacts, createRelationTypeSide, iRelationType, transArtifact);
                }
                if ((relatedArtifacts1 = readable.getRelated(createRelationTypeSide1 = RelationTypeSide.create((RelationTypeToken)iRelationType, (RelationSide)RelationSide.SIDE_A))).size() <= 0) continue;
                TranferableArtifactLoader.fillRelationsdup((ResultSet<ArtifactReadable>)relatedArtifacts1, createRelationTypeSide1, iRelationType, transArtifact);
            }
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)" Exception while copying relations . Some relation will not be copied ");
        }
    }

    private static void fillRelationsdup(ResultSet<ArtifactReadable> relatedArtifacts, RelationTypeSide side, RelationTypeToken iRelationType, TransferableArtifact transArtifact) {
        ArrayList<TransferableArtifact> list1 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : relatedArtifacts) {
            ArtifactReadable user = (ArtifactReadable)OseeCoreData.getOrcsApi().getQueryFactory().fromBranch((BranchId)artifactReadable.getBranch()).andGuid(artifactReadable.getGuid()).getResults().getExactlyOne();
            TransferableArtifact art = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(user, (ITransferableArtifact)art);
            list1.add(art);
        }
        transArtifact.putRelations(String.valueOf(iRelationType.getName()) + "##" + side.getSide().name(), list1);
    }

    public static void copyBasicInfoToTransferableArtifact(ArtifactReadable readable, ITransferableArtifact rootArt) throws OseeCoreException {
        OseeCoreData.getOrcsApi();
        String name = readable.getName();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(name);
        rootArt.setName(name);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        rootArt.setId(readable.getId());
        ArrayList<String> list3 = new ArrayList<String>();
        if (readable.getArtifactType().toString().equalsIgnoreCase("IC_Component")) {
            rootArt.setArtifactType("Component");
            list3.add("Component");
        } else {
            rootArt.setArtifactType(readable.getArtifactType().toString());
            list3.add(readable.getArtifactType().toString());
        }
        rootArt.putAttributes("", list3);
        rootArt.putAttributes(CoreAttributeTypes.Name.toString(), list1);
        rootArt.putAttributes("guid", list2);
        rootArt.setBranchGuid(readable.getBranch().getId());
    }

    public static void copyAllInfoToTransferableArtifact(ArtifactReadable readable, ITransferableArtifact mainArt) throws OseeCoreException {
        OseeCoreData.getOrcsApi();
        String name = readable.getName();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(name);
        mainArt.setName(name);
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                listTemp.add(attributeReadable.getValue().toString());
            }
            mainArt.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        mainArt.setId(readable.getId());
        ArrayList<String> list3 = new ArrayList<String>();
        mainArt.setArtifactType(readable.getArtifactType().toString());
        list3.add(readable.getArtifactType().toString());
        mainArt.putAttributes("", list3);
        mainArt.putAttributes(CoreAttributeTypes.Name.toString(), list1);
        mainArt.putAttributes("guid", list2);
        mainArt.setBranchGuid(readable.getBranch().getId());
    }

    public static void copyTaskInfoToTransferableArtifact(ArtifactReadable readable, TransferableArtifact transArt) throws OseeCoreException {
        OseeCoreData.getOrcsApi();
        String name = readable.getName();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(name);
        transArt.setName(name);
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                listTemp.add(attributeReadable.getValue().toString());
            }
            transArt.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArt.setId(readable.getId());
        ArrayList<String> list3 = new ArrayList<String>();
        transArt.setArtifactType(readable.getArtifactType().toString());
        list3.add(readable.getArtifactType().toString());
        transArt.putAttributes("", list3);
        transArt.putAttributes(CoreAttributeTypes.Name.toString(), list1);
        transArt.putAttributes("guid", list2);
        ResultSet results = readable.getRelated(AtsRelationTypes.TeamWfToTask_Task);
        ArrayList<TransferableArtifact> list11 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : results) {
            TransferableArtifact art = new TransferableArtifact();
            TranferableArtifactLoader.copyAllInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)art);
            list11.add(art);
        }
        transArt.putRelations(AtsRelationTypes.TeamWfToTask_Task.getName(), list11);
        ResultSet related = readable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
        ArrayList<TransferableArtifact> list12 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : related) {
            TransferableArtifact ar = new TransferableArtifact();
            TranferableArtifactLoader.copyAllInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
            list12.add(ar);
        }
        transArt.putRelations(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.getName(), list12);
        transArt.setBranchGuid(readable.getBranch().getId());
    }

    public static ListenableFuture<?> copy(final ArtifactReadable readable, final TransferableArtifact transArt, ListeningExecutorService executorService) {
        return executorService.submit(new Runnable(){

            @Override
            public void run() {
                TranferableArtifactLoader.copyBasicTaskInfoToTransferableArtifact(readable, transArt);
            }
        });
    }

    public static void copyBasicTaskInfoToTransferableArtifact(ArtifactReadable readable, TransferableArtifact transArt) throws OseeCoreException {
        OseeCoreData.getOrcsApi();
        String name = readable.getName();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(name);
        transArt.setName(name);
        Collection existingAttributeTypes = readable.getExistingAttributeTypes();
        for (AttributeTypeToken iAttributeType : existingAttributeTypes) {
            ResultSet attributes = readable.getAttributes(iAttributeType);
            ArrayList<String> listTemp = new ArrayList<String>();
            for (AttributeReadable attributeReadable : attributes) {
                if (attributeReadable.getValue() != null) {
                    listTemp.add(attributeReadable.getValue().toString());
                    continue;
                }
                listTemp.add("");
            }
            transArt.putAttributes(iAttributeType.toString(), listTemp);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(readable.getGuid());
        transArt.setId(readable.getId());
        ArrayList<String> list3 = new ArrayList<String>();
        transArt.setArtifactType(readable.getArtifactType().toString());
        list3.add(readable.getArtifactType().toString());
        transArt.setLocalId(readable.getIdIntValue());
        transArt.putAttributes("", list3);
        transArt.putAttributes(CoreAttributeTypes.Name.toString(), list1);
        transArt.putAttributes("guid", list2);
        ResultSet results = readable.getRelated(AtsRelationTypes.TeamWfToTask_Task);
        ArrayList<TransferableArtifact> list11 = new ArrayList<TransferableArtifact>();
        for (ArtifactReadable artifactReadable : results) {
            TransferableArtifact art = new TransferableArtifact();
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(artifactReadable, (ITransferableArtifact)art);
            list11.add(art);
        }
        transArt.putRelations(AtsRelationTypes.TeamWfToTask_Task.getName(), list11);
        transArt.setBranchGuid(readable.getBranch().getId());
    }
}

