/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init.internal;

import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.services.IOseeCachingService;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.database.init.IDatabaseInitConfiguration;
import org.eclipse.osee.framework.database.init.IDbInitializationTask;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;

public class DbBootstrapTask
implements IDbInitializationTask {
    private IDatabaseInitConfiguration configuration;

    public void setConfiguration(IDatabaseInitConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void run() {
        Conditions.checkNotNull((Object)this.configuration, (String)"DbInitConfiguration Info");
        OseeProperties.setInDbInit((boolean)true);
        DatastoreEndpoint datastoreEndpoint = ((OseeClient)OsgiUtil.getService(this.getClass(), OseeClient.class)).getDatastoreEndpoint();
        datastoreEndpoint.initialize();
        Conditions.checkNotNull((Object)BranchManager.getBranchToken((BranchId)CoreBranches.SYSTEM_ROOT), (String)"System root was not created - ");
        IOseeCachingService typeService = (IOseeCachingService)OsgiUtil.getService(this.getClass(), IOseeCachingService.class);
        typeService.clearAll();
    }
}

