/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.database.init;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.client.BaseCredentialProvider;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.client.ICredentialProvider;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.database.init.DefaultDbInitTasks;
import org.eclipse.osee.framework.database.init.IDatabaseInitConfiguration;
import org.eclipse.osee.framework.database.init.IDbInitChoiceEnum;
import org.eclipse.osee.framework.database.init.IDbInitializationRule;
import org.eclipse.osee.framework.database.init.IDbInitializationTask;
import org.eclipse.osee.framework.database.init.internal.Activator;
import org.eclipse.osee.framework.database.init.internal.DbBootstrapTask;
import org.eclipse.osee.framework.database.init.internal.GroupSelection;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DatabaseInitializationOperation
extends AbstractOperation {
    private final String preSelectedChoice;
    public static ArtifactToken MAPPING_ARTIFACT;

    private DatabaseInitializationOperation(String preSelectedChoice) {
        super("Database Initialization", "org.eclipse.osee.framework.database.init");
        this.preSelectedChoice = preSelectedChoice;
        MAPPING_ARTIFACT = ArtifactToken.valueOf((long)5443258L, (String)"AOkJ_kFNbEXCS7UjmfwA", (String)"DataRightsFooters", (BranchId)BranchId.SENTINEL, (ArtifactTypeToken)CoreArtifactTypes.GeneralData);
    }

    public static void execute(IDbInitChoiceEnum choice) {
        DatabaseInitializationOperation operation = new DatabaseInitializationOperation(choice.name());
        Operations.executeWorkAndCheckStatus((IOperation)operation);
    }

    private String getPreSelectedChoice() {
        return this.preSelectedChoice;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.checkServerPreconditions();
        ClientSessionManager.authenticate((ICredentialProvider)new BaseCredentialProvider(){

            public OseeCredential getCredential() {
                OseeCredential credential = super.getCredential();
                credential.setUserName(SystemUser.BootStrap.getName());
                return credential;
            }
        });
        String dbName = ClientSessionManager.getDataStoreName();
        if (ClientSessionManager.isProductionDataStore()) {
            throw new OseeArgumentException(String.format("You are not allowed to run config client against production: [%s].\nExiting.", dbName), new Object[0]);
        }
        System.out.println("Begin Database Initialization...");
        OseeClientProperties.setInDbInit((boolean)true);
        try {
            try {
                this.processTasks();
                System.out.println("Database Initialization Complete");
            }
            catch (Exception ex) {
                OseeLog.log(DatabaseInitializationOperation.class, (Level)Level.SEVERE, (Throwable)ex);
                OseeCoreException.wrapAndThrow((Throwable)ex);
                OseeClientProperties.setInDbInit((boolean)false);
            }
        }
        finally {
            OseeClientProperties.setInDbInit((boolean)false);
        }
    }

    private void checkValidExtension(IExtension extension, String pointId) {
        Conditions.checkNotNull((Object)extension, (String)"Extension", (String)"Unable to locate extension [%s]", (Object[])new Object[]{pointId});
        String extensionPointId = extension.getExtensionPointUniqueIdentifier();
        Conditions.checkExpressionFailOnTrue((!DefaultDbInitTasks.DB_INIT_TASK.getExtensionId().equals(extensionPointId) ? 1 : 0) != 0, (String)"Unknown extension id [%s] from extension [%s]", (Object[])new Object[]{extensionPointId, pointId});
    }

    private void processTasks() {
        OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Configuring Database...");
        IDatabaseInitConfiguration configuration = this.getConfiguration();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        for (String pointId : configuration.getTaskExtensionIds()) {
            IExtension extension = extensionRegistry.getExtension(pointId);
            this.checkValidExtension(extension, pointId);
            this.runDbInitTasks(configuration, extension);
        }
        OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Database Initialization Complete.");
    }

    private IDatabaseInitConfiguration getConfiguration() {
        String selectedChoice = null;
        GroupSelection selector = GroupSelection.getInstance();
        List<String> choices = selector.getChoices();
        if (choices.size() == 1) {
            selectedChoice = choices.get(0);
        } else {
            int selection = -1;
            if (Strings.isValid((String)this.getPreSelectedChoice())) {
                selection = choices.indexOf(this.getPreSelectedChoice());
            }
            selectedChoice = selection <= -1 ? this.getInitChoiceFromUser("Select Init Group To Run.", choices) : choices.get(selection);
        }
        OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"DB Config Choice Selected: [%s]", (Object[])new Object[]{selectedChoice});
        return selector.getDbInitConfiguration(selectedChoice);
    }

    private String getInitChoiceFromUser(String message, List<String> choices) {
        int selection = -1;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (selection == -1) {
            try {
                System.out.println(message);
                int i = 0;
                while (i < choices.size()) {
                    System.out.println("   " + i + ") " + choices.get(i));
                    ++i;
                }
                System.out.println("Enter: 0 - " + (choices.size() - 1));
                String line = stdin.readLine();
                if (line != null) {
                    selection = Integer.parseInt(line);
                }
                if (selection >= 0 && selection < choices.size()) continue;
                System.out.println("Invalid selection:  Index [" + selection + "] is out of range.");
                selection = -1;
            }
            catch (Exception ex) {
                System.out.println("Invalid selection:  Index [" + selection + "] is out of range.");
                ex.printStackTrace();
            }
        }
        return choices.get(selection);
    }

    private void runDbInitTasks(IDatabaseInitConfiguration configuration, IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        String classname = null;
        String bundleName = null;
        String initRuleClassName = null;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("DatabaseInitializationTask".equals(el.getName())) {
                classname = el.getAttribute("classname");
                bundleName = el.getContributor().getName();
                initRuleClassName = el.getAttribute("rule");
            }
            ++n2;
        }
        try {
            if (classname != null && bundleName != null) {
                Bundle bundle = Platform.getBundle(bundleName);
                boolean isExecutionAllowed = true;
                if (Strings.isValid(initRuleClassName)) {
                    isExecutionAllowed = false;
                    IDbInitializationRule rule = this.createTask(bundle, initRuleClassName);
                    isExecutionAllowed = rule.isAllowed();
                }
                OseeLog.logf(Activator.class, (Level)(isExecutionAllowed ? Level.INFO : Level.WARNING), (String)"%s [%s] execution rule [%s]", (Object[])new Object[]{isExecutionAllowed ? "Starting" : "Skipping", extension.getUniqueIdentifier(), Strings.isValid((String)initRuleClassName) ? initRuleClassName : "Default"});
                if (isExecutionAllowed) {
                    IDbInitializationTask task = (IDbInitializationTask)bundle.loadClass(classname).newInstance();
                    if (task instanceof DbBootstrapTask) {
                        ((DbBootstrapTask)task).setConfiguration(configuration);
                    }
                    task.run();
                }
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private IDbInitializationRule createTask(Bundle bundle, String initRuleClassName) {
        Class taskClass = null;
        try {
            taskClass = bundle.loadClass(initRuleClassName);
        }
        catch (Exception ex) {
            Bundle dbInitBundle = FrameworkUtil.getBundle(DatabaseInitializationOperation.class);
            try {
                taskClass = dbInitBundle.loadClass(initRuleClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OseeCoreException((Throwable)ex, "Unable to find rule [%s] in bundle [%s] or in [%s]", new Object[]{initRuleClassName, bundle.getSymbolicName(), dbInitBundle.getSymbolicName()});
            }
        }
        try {
            return (IDbInitializationRule)taskClass.newInstance();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private boolean isApplicationServerAlive(String applicationServerUrl) {
        boolean canConnection = false;
        try {
            URL url = new URL(applicationServerUrl);
            URLConnection connection = url.openConnection();
            connection.connect();
            canConnection = true;
        }
        catch (Exception exception) {}
        return canConnection;
    }

    private void checkServerPreconditions() {
        String serverUrl = OseeClientProperties.getOseeApplicationServer();
        Conditions.checkNotNullOrEmpty((String)serverUrl, (String)"Application Server Address", (String)"Database initialization requires an application server to be set by default.", (Object[])new Object[0]);
        boolean serverOk = this.isApplicationServerAlive(serverUrl);
        Conditions.checkExpressionFailOnTrue((!serverOk ? 1 : 0) != 0, (String)"Error connecting to application server [%s].\nPlease ensure server is running and try again.", (Object[])new Object[]{serverUrl});
    }
}

