/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.enums.StorageState;
import org.eclipse.osee.framework.core.model.AbstractOseeField;
import org.eclipse.osee.framework.core.model.IOseeField;
import org.eclipse.osee.framework.core.model.IOseeStorable;
import org.eclipse.osee.framework.core.model.OseeField;
import org.eclipse.osee.framework.core.model.internal.fields.UniqueIdField;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class AbstractOseeType
extends NamedIdBase
implements IOseeStorable {
    public static final String NAME_FIELD_KEY = "osee.name.field";
    public static final String UNIQUE_ID_FIELD_KEY = "osee.unique.id.field";
    private StorageState itemState = StorageState.CREATED;
    private final Map<String, IOseeField<?>> fieldMap = new HashMap();

    protected AbstractOseeType(Long id, String name) {
        super(id, name);
        this.addField(UNIQUE_ID_FIELD_KEY, new UniqueIdField());
        this.addField(NAME_FIELD_KEY, new OseeField<String>(name));
    }

    protected synchronized void addField(String key, AbstractOseeField<?> toAdd) {
        this.fieldMap.put(key, toAdd);
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    protected <T> IOseeField<T> getField(String key) {
        AbstractOseeField field = (AbstractOseeField)this.fieldMap.get(key);
        Conditions.checkNotNull((Object)field, (String)key);
        return field;
    }

    public boolean isFieldDirty(String key) {
        return this.getField(key).isDirty();
    }

    public boolean areFieldsDirty(String ... keys) {
        boolean result = false;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            result |= this.isFieldDirty(key);
            ++n2;
        }
        return result;
    }

    protected <T> T getFieldValue(String key) {
        IOseeField<T> field = this.getField(key);
        return field.get();
    }

    protected <T> T getFieldValueLogException(T defaultValue, String key) {
        T value = defaultValue;
        try {
            value = this.getFieldValue(key);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AbstractOseeType.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected <T> void setField(String key, T value) {
        StorageState oldState;
        IOseeField<T> field = this.getField(key);
        field.set(value);
        if (field.isDirty() && StorageState.CREATED != (oldState = this.getStorageState()) && StorageState.PURGED != oldState) {
            this.setStorageState(StorageState.MODIFIED);
        }
    }

    protected <T> void setFieldLogException(String key, T value) {
        try {
            this.setField(key, value);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AbstractOseeType.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public String getName() {
        return this.getFieldValueLogException("", NAME_FIELD_KEY);
    }

    public void setName(String name) {
        this.setFieldLogException(NAME_FIELD_KEY, name);
    }

    @Override
    public final boolean isDirty() {
        boolean isDirty = false;
        for (IOseeField<?> field : this.fieldMap.values()) {
            if (!field.isDirty()) continue;
            isDirty = true;
            break;
        }
        return isDirty;
    }

    @Override
    public final void clearDirty() {
        if (StorageState.PURGED != this.getStorageState()) {
            this.setStorageState(StorageState.LOADED);
        }
        for (IOseeField<?> field : this.fieldMap.values()) {
            field.clearDirty();
        }
    }

    @Override
    public StorageState getStorageState() {
        return this.itemState;
    }

    public void setStorageState(StorageState storageState) {
        this.itemState = storageState;
    }
}

