/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.ReqNumbering;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;

public class RequirementReorderOperation
extends AbstractBlam {
    private SkynetTransaction transaction;

    public Collection<String> getCategories() {
        return Arrays.asList("Define");
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        List artifacts = variableMap.getArtifacts("artifacts");
        BranchToken branch = ((Artifact)artifacts.get(0)).getBranch();
        this.transaction = TransactionManager.createTransaction((BranchId)branch, (String)"Fix Requirement Ordering BLAM");
        for (Artifact input : artifacts) {
            this.reorderChildren(input);
        }
        this.transaction.execute();
    }

    public void reorderChildren(Artifact parent) {
        List oldChildren = parent.getChildren();
        List children = parent.getChildren();
        Collections.sort(children, new ParagraphComparator());
        if (!oldChildren.equals(children)) {
            parent.setRelationOrder(CoreRelationTypes.DefaultHierarchical_Child, children);
            parent.persist(this.transaction);
        }
        for (Artifact child : children) {
            this.reorderChildren(child);
        }
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"artifacts\" /></xWidgets>";
    }

    public String getName() {
        return "Fix Requirement Ordering";
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }

    private class ParagraphComparator
    implements Comparator<Artifact> {
        private ParagraphComparator() {
        }

        @Override
        public int compare(Artifact o1, Artifact o2) {
            try {
                ReqNumbering n1 = new ReqNumbering((String)o1.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber));
                ReqNumbering n2 = new ReqNumbering((String)o2.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber));
                return n1.compareTo(n2);
            }
            catch (OseeCoreException oseeCoreException) {
                return 0;
            }
        }
    }
}

