/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FindDuplicateArtifactNames
extends AbstractBlam {
    private static final String ROOT_ARTIFACTS = "Root Artifacts";
    private XCombo branchViewWidget;
    private XListDropViewer viewerWidget;

    public String getName() {
        return "Find Artifacts With Duplicate Names";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        File file = OseeData.getFile((String)("DUP_NAMES_" + dateFormat.format(date) + ".xml"));
        ExcelXmlWriter excelWriter = new ExcelXmlWriter(file);
        List artifacts = variableMap.getArtifacts(ROOT_ARTIFACTS);
        BranchToken branch = ((Artifact)artifacts.get(0)).getBranch();
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        Set findExcludedArtifactsByView = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)branch);
        excelWriter.startSheet("Report", 6);
        excelWriter.writeRow(new Object[]{"Root Artifact", "Subsystem", "Artifact Name", "Artifact Type", "Art Id", "Guid"});
        for (Artifact artifact : artifacts) {
            List children = artifact.getChildren();
            for (Artifact child : children) {
                List artifactListFromName = ArtifactQuery.getArtifactListFromName((String)child.getName(), (BranchId)branch);
                if (artifactListFromName != null) {
                    ViewIdUtility.removeExcludedArtifacts(artifactListFromName.iterator(), (Set)findExcludedArtifactsByView);
                }
                if (artifactListFromName == null || artifactListFromName.size() <= 1) continue;
                for (Artifact art : artifactListFromName) {
                    String subsystem = art.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, "");
                    excelWriter.writeRow(new Object[]{artifact.getName(), subsystem, art.getName(), art.getArtifactType().getName(), art.getArtId(), art.getGuid()});
                }
            }
        }
        excelWriter.endSheet();
        excelWriter.endWorkbook();
        Program.launch((String)file.getAbsolutePath());
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(ROOT_ARTIFACTS)) {
            this.viewerWidget = (XListDropViewer)xWidget;
            this.viewerWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (FindDuplicateArtifactNames.this.branchViewWidget != null) {
                        BranchToken branch;
                        FindDuplicateArtifactNames.this.branchViewWidget.setEditable(true);
                        List arts = FindDuplicateArtifactNames.this.viewerWidget.getArtifacts();
                        if (arts != null && !arts.isEmpty() && (branch = ((Artifact)arts.iterator().next()).getBranch()) != null && branch.isValid()) {
                            FindDuplicateArtifactNames.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            FindDuplicateArtifactNames.this.branchViewWidget.setDataStrings(FindDuplicateArtifactNames.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Root Artifacts\" />");
        builder.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Publish.Check");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

