/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateCommonItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.osgi.framework.Bundle;

public class XNavigateCommonItems {
    private static Set<IXNavigateCommonItem> items;
    public static final boolean debug = false;

    public static void addCommonNavigateItems(List<XNavigateItem> items, List<String> excludeSectionIds) {
        try {
            for (IXNavigateCommonItem item : XNavigateCommonItems.getProviders()) {
                if (excludeSectionIds.contains(item.getSectionId())) continue;
                ElapsedTime time = new ElapsedTime("NVI - " + item.getClass().getSimpleName(), false);
                item.createCommonSection(items, excludeSectionIds);
                time.end();
            }
        }
        catch (Exception ex) {
            OseeLog.log(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        XNavigateCommonItems.createUtilItemsSection(items, excludeSectionIds);
    }

    public static void createUtilItemsSection(List<XNavigateItem> items, List<String> excludeSectionIds) {
        try {
            XNavigateItem utilItems = new XNavigateItem(null, "Util", PluginUiImage.GEAR);
            for (IXNavigateCommonItem item : XNavigateCommonItems.getProviders()) {
                item.addUtilItems(utilItems);
            }
            items.add(utilItems);
        }
        catch (Exception ex) {
            OseeLog.log(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private static synchronized Set<IXNavigateCommonItem> getProviders() {
        IExtension[] extensions;
        if (items != null) {
            return items;
        }
        items = new HashSet<IXNavigateCommonItem>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.framework.ui.plugin.XCommonNavigateItem");
        if (point == null) {
            OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access XCommonNavigateItem extension point");
            return items;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("XCommonNavigateItem")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            items.add((IXNavigateCommonItem)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading XCommonNavigateItem extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return items;
    }
}

