/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.PlatformUI;

public class WindowLocal<T> {
    private static final Object NON_WINDOW = new Object();
    private final Map<Object, T> valueMap = new HashMap<Object, T>();
    private final WindowKey windowKey = new WindowKey();

    protected T initialValue() {
        return null;
    }

    public T get() {
        Object key = this.getWindowLocalKey();
        T value = this.valueMap.get(key);
        if (value == null) {
            value = this.initialValue();
            this.set(value);
        }
        return value;
    }

    public void set(T value) {
        this.valueMap.put(this.getWindowLocalKey(), value);
    }

    public void remove() {
        this.valueMap.remove(this.getWindowLocalKey());
    }

    private Object getWindowLocalKey() {
        Object key;
        if (PlatformUI.isWorkbenchRunning()) {
            Displays.ensureInDisplayThread((Runnable)this.windowKey);
            key = this.windowKey.getKey();
        } else {
            key = NON_WINDOW;
        }
        return key;
    }

    private class WindowKey
    implements Runnable {
        private Object key;

        private WindowKey() {
        }

        @Override
        public void run() {
            this.key = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }

        public Object getKey() {
            return this.key;
        }
    }
}

