/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class UniversalGroup {
    public static Collection<Artifact> getGroups(BranchId branch) {
        List<Artifact> artifacts = null;
        try {
            artifacts = ArtifactQuery.getArtifactListFromType(CoreArtifactTypes.UniversalGroup, branch);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            artifacts = new LinkedList<Artifact>();
        }
        return artifacts;
    }

    public static Collection<Artifact> getGroupsNotRoot(BranchId branch) {
        HashSet<Artifact> groups = new HashSet<Artifact>();
        for (Artifact group : UniversalGroup.getGroups(branch)) {
            if (group.getName().equals("Root Artifact")) continue;
            groups.add(group);
        }
        return groups;
    }

    public static Collection<Artifact> getGroups(String groupName, BranchId branch) {
        try {
            return ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.UniversalGroup, groupName, branch);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new ArrayList<Artifact>();
        }
    }

    public static Artifact getGroupOrNull(ArtifactToken groupToken, BranchToken branch) {
        try {
            return ArtifactQuery.getArtifactFromId((ArtifactId)groupToken, (BranchId)branch);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {
            return null;
        }
    }

    public static Artifact addGroup(String name, BranchToken branch, SkynetTransaction transaction) {
        if (!UniversalGroup.getGroups(name, (BranchId)branch).isEmpty()) {
            throw new OseeArgumentException("Group Already Exists", new Object[0]);
        }
        Artifact groupArt = ArtifactTypeManager.addArtifact(CoreArtifactTypes.UniversalGroup, branch, name);
        groupArt.persist(transaction);
        Artifact groupRoot = UniversalGroup.getTopUniversalGroupArtifact((BranchId)branch);
        groupRoot.addRelation(CoreRelationTypes.UniversalGrouping_Members, groupArt);
        groupRoot.persist(transaction);
        return groupArt;
    }

    public static Artifact addGroup(ArtifactToken groupToken, BranchToken branch, SkynetTransaction transaction) {
        if (UniversalGroup.getGroupOrNull(groupToken, branch) != null) {
            throw new OseeArgumentException("Group Already Exists", new Object[0]);
        }
        Artifact groupArt = ArtifactTypeManager.addArtifact(CoreArtifactTypes.UniversalGroup, branch, groupToken.getName(), groupToken.getId());
        groupArt.persist(transaction);
        Artifact groupRoot = UniversalGroup.getTopUniversalGroupArtifact((BranchId)branch);
        groupRoot.addRelation(CoreRelationTypes.UniversalGrouping_Members, groupArt);
        groupRoot.persist(transaction);
        return groupArt;
    }

    public static Artifact getTopUniversalGroupArtifact(BranchId branch) {
        return ArtifactQuery.getArtifactFromId((ArtifactId)CoreArtifactTokens.UniversalGroupRoot, branch);
    }
}

