/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.access;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.access.AbstractAccessControlService;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.client.AccessTopicEvent;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.access.UserServiceImpl;
import org.eclipse.osee.framework.skynet.core.access.internal.AccessStoreOperations;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public class AccessControlServiceImpl
extends AbstractAccessControlService {
    private JdbcClient jdbcClient;
    private OrcsTokenService tokenService;

    public void bindJdbcService(JdbcService jdbcService) {
        this.jdbcClient = jdbcService.getClient();
    }

    public void bindTokenService1(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void start() {
        this.setStoreOperations(new AccessStoreOperations(this.jdbcClient));
        this.storeOps.setCache(this.cache);
    }

    public boolean isOseeAdmin() {
        return UserManager.getUser().isOseeAdmin();
    }

    public ArtifactToken getUser() {
        return UserManager.getUser();
    }

    public XResultData isDeleteable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        super.isDeleteable(artifacts, results);
        for (ArtifactToken artifactToken : artifacts) {
            if (!artifactToken.isOnBranch((BranchId)CoreBranches.COMMON)) continue;
            Collection<BranchToken> branches = BranchManager.getBranchesByAssocArt(artifactToken);
            for (BranchToken branchTok : branches) {
                BranchState state = BranchManager.getState((BranchId)branchTok);
                if (!state.isCreated() && !state.isModified() && !state.isCommitted()) continue;
                results.errorf("Cannot delete artId %s because it is the associated artifact of branch(es) %s\n", new Object[]{artifactToken.toStringWithId(), branches.toString()});
            }
        }
        return results;
    }

    public boolean isBaselineBranch(BranchToken branch) {
        return BranchManager.getBranch((BranchId)branch).getBranchType().isBaselineBranch();
    }

    public ArtifactToken getUserByArtId(ArtifactId subjectArtId) {
        return UserManager.getUserByArtId(subjectArtId);
    }

    protected boolean isInDbInit() {
        return OseeProperties.isInDbInit();
    }

    public boolean isInDb(ArtifactToken artifact) {
        boolean isInDb = false;
        if (artifact instanceof Artifact) {
            isInDb = ((Artifact)artifact).isInDb();
        } else {
            Artifact art = ArtifactQuery.getArtifactFromToken(artifact);
            if (art != null) {
                isInDb = art.isInDb();
            }
        }
        return isInDb;
    }

    public boolean isReadOnly(ArtifactToken artifact) {
        try {
            if (artifact instanceof Artifact) {
                boolean deleted = ((Artifact)artifact).isDeleted();
                boolean historical = ((Artifact)artifact).isHistorical();
                boolean hasPermission = this.hasArtifactPermission(artifact, PermissionEnum.WRITE, null).isSuccess();
                return deleted || historical || !hasPermission;
            }
            return true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AbstractAccessControlService.class, (Level)Level.SEVERE, (Throwable)ex);
            return true;
        }
    }

    public ArtifactToken getArtifactFromId(ArtifactId artifactId, BranchToken branch) {
        return ArtifactQuery.getArtifactTokenFromId((BranchId)branch, artifactId);
    }

    public void kickAccessTopicEvent(AccessTopicEventPayload payload) {
        try {
            OseeEventManager.kickAccessTopicEvent((Object)this, payload, AccessTopicEvent.ACCESS_ARTIFACT_LOCK_MODIFIED);
        }
        catch (Exception ex) {
            OseeLog.log(((Object)((Object)this)).getClass(), (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public UserService getUserGroupService() {
        return UserServiceImpl.instance();
    }

    public Collection<ArtifactToken> getArtifactListFromType(ArtifactTypeToken artifactType, BranchToken branch) {
        return Collections.castAll(ArtifactQuery.getArtifactListFromType(artifactType, (BranchId)branch));
    }

    public void populateBranchAccessControlList() {
        Consumer<JdbcStatement> consumer = stmt -> {
            ArtifactId subjectId = ArtifactId.valueOf((Long)stmt.getLong("privilege_entity_id"));
            BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
            Branch branch = BranchManager.getBranch(branchId);
            PermissionEnum permission = PermissionEnum.getPermission((int)stmt.getInt("permission_id"));
            ArtifactTypeToken subjectArtifactType = this.tokenService.getArtifactType(Long.valueOf(stmt.getLong("art_type_id")));
            this.brchAclOps.populateBranchAccessControlListEntry(subjectId, subjectArtifactType, (BranchToken)branch, permission);
        };
        this.jdbcClient.runQuery(consumer, "SELECT bac1.*, art1.art_type_id FROM osee_artifact art1, osee_branch_acl bac1 WHERE art1.art_id = bac1.privilege_entity_id", new Object[0]);
    }

    public void populateArtifactAccessControlList() {
        Consumer<JdbcStatement> consumer = stmt -> {
            UserId subjectId = UserId.valueOf((Long)stmt.getLong("privilege_entity_id"));
            ArtifactId artifactId = ArtifactId.valueOf((Long)stmt.getLong("art_id"));
            BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
            PermissionEnum permission = PermissionEnum.getPermission((int)stmt.getInt("permission_id"));
            ArtifactTypeToken subjectArtifactType = this.tokenService.getArtifactType(Long.valueOf(stmt.getLong("art_type_id")));
            this.artAclOps.populateArtifactAccessControlListEntry((ArtifactId)subjectId, artifactId, branchId, permission, subjectArtifactType);
        };
        this.jdbcClient.runQuery(consumer, "SELECT aac1.*, art1.art_type_id FROM osee_artifact art1, osee_artifact_acl aac1 WHERE art1.art_id = aac1.privilege_entity_id", new Object[0]);
    }

    public void populateGroupMembers(ArtifactId groupId) {
        if (!this.cache.groupToSubjectsCache.containsKey((Object)groupId.getId())) {
            this.jdbcClient.runQuery(stmt -> {
                ArtifactId groupMember = ArtifactId.valueOf((Long)stmt.getLong("b_art_id"));
                this.userGrpOps.populateGroupMembersEntry(groupId, groupMember);
            }, "SELECT b_art_id FROM osee_relation_link WHERE a_art_id = ? AND rel_link_type_id = ? ORDER BY b_art_id", new Object[]{groupId, CoreRelationTypes.Users_User});
        }
    }
}

