/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.lifecycle;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.framework.lifecycle.AbstractLifecycleVisitor;
import org.eclipse.osee.framework.lifecycle.LifecycleOpHandler;
import org.eclipse.osee.framework.lifecycle.internal.OperationPointId;

public abstract class AbstractLifecyclePoint<H extends LifecycleOpHandler>
extends AbstractLifecycleVisitor<H> {
    protected AbstractLifecyclePoint() {
    }

    @Override
    protected final IStatus dispatch(IProgressMonitor monitor, H handler, String sourceId) {
        this.initializeHandlerData(handler);
        IStatus status = Status.OK_STATUS;
        OperationPointId pointId = OperationPointId.toEnum(sourceId);
        switch (pointId) {
            case CHECK_CONDITION_ID: {
                status = handler.onCheck(monitor);
                break;
            }
            case PRE_CONDITION_ID: {
                status = handler.onPreCondition(monitor);
                break;
            }
            case POST_CONDITION_ID: {
                status = handler.onPostCondition(monitor);
                break;
            }
        }
        return status;
    }

    protected abstract void initializeHandlerData(H var1);
}

