/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.activemq;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.ConnectionNodeFactory;
import org.eclipse.osee.framework.messaging.NodeInfo;
import org.eclipse.osee.framework.messaging.internal.Activator;
import org.eclipse.osee.framework.messaging.internal.FailoverConnectionNode;
import org.eclipse.osee.framework.messaging.internal.activemq.ConnectionNodeActiveMq;
import org.eclipse.osee.framework.messaging.internal.activemq.OseeExceptionListener;

public class ConnectionNodeFactoryImpl
implements ConnectionNodeFactory {
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final String version;
    private final String sourceId;

    public ConnectionNodeFactoryImpl(String version, String sourceId, ExecutorService executor) {
        this.version = version;
        this.sourceId = sourceId;
        this.executor = executor;
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public synchronized ConnectionNode create(NodeInfo nodeInfo) {
        OseeExceptionListener exceptionListener = new OseeExceptionListener();
        ConnectionNodeActiveMq node = new ConnectionNodeActiveMq(this.version, this.sourceId, nodeInfo, this.executor, exceptionListener);
        OseeLog.log(Activator.class, (Level)Level.FINEST, (String)"Going to start a connection node.");
        try {
            node.start();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(ConnectionNodeFactoryImpl.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        OseeLog.log(Activator.class, (Level)Level.FINE, (String)"Started a connection node.");
        return new FailoverConnectionNode(node, this.scheduledExecutor, exceptionListener);
    }
}

