/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.ApplicabilityVisitor;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.CustomLabelVisitor;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public class UseValueOfResolution
extends BugResolution {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final Set<String> primitiveWrapperClasses = new HashSet<String>();
    private boolean isDouble;
    private boolean isFloatingPoint;

    public boolean isStaticImport() {
        return false;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        ClassInstanceCreation primitiveTypeCreation = this.findPrimitiveTypeCreation(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        if (primitiveTypeCreation == null) {
            throw new BugResolutionException("Primitive type creation not found.");
        }
        MethodInvocation valueOfInvocation = this.createValueOfInvocation(rewrite, workingUnit, primitiveTypeCreation);
        rewrite.replace((ASTNode)primitiveTypeCreation, (ASTNode)valueOfInvocation, null);
    }

    @CheckForNull
    protected ClassInstanceCreation findPrimitiveTypeCreation(ASTNode node) {
        PrimitiveTypeCreationFinder visitor = new PrimitiveTypeCreationFinder();
        node.accept((ASTVisitor)visitor);
        return visitor.getPrimitiveTypeCreation();
    }

    protected MethodInvocation createValueOfInvocation(ASTRewrite rewrite, CompilationUnit compilationUnit, ClassInstanceCreation primitiveTypeCreation) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)primitiveTypeCreation);
        AST ast = rewrite.getAST();
        MethodInvocation valueOfInvocation = ast.newMethodInvocation();
        valueOfInvocation.setName(ast.newSimpleName(VALUE_OF_METHOD_NAME));
        ITypeBinding binding = primitiveTypeCreation.getType().resolveBinding();
        if (this.isStaticImport()) {
            ASTUtil.addStaticImports(rewrite, compilationUnit, binding.getQualifiedName() + "." + VALUE_OF_METHOD_NAME);
        } else {
            valueOfInvocation.setExpression((Expression)ast.newSimpleName(binding.getName()));
        }
        List arguments = primitiveTypeCreation.arguments();
        List newArguments = valueOfInvocation.arguments();
        for (Object argument : arguments) {
            Expression expression = (Expression)rewrite.createCopyTarget((ASTNode)argument);
            newArguments.add(expression);
        }
        return valueOfInvocation;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    @Override
    protected ASTVisitor getCustomLabelVisitor() {
        return new PrimitiveTypeCreationFinder();
    }

    @Override
    public void setOptions(@Nonnull Map<String, String> options) {
        this.isFloatingPoint = Boolean.parseBoolean(options.get("isFloatingPoint"));
        this.isDouble = Boolean.parseBoolean(options.get("isDouble"));
    }

    @Override
    protected ASTVisitor getApplicabilityVisitor() {
        return new PrimitiveTypeCreationFinder();
    }

    static {
        primitiveWrapperClasses.add("java.lang.Double");
        primitiveWrapperClasses.add("java.lang.Integer");
        primitiveWrapperClasses.add("java.lang.Boolean");
        primitiveWrapperClasses.add("java.lang.Float");
    }

    protected class PrimitiveTypeCreationFinder
    extends ASTVisitor
    implements CustomLabelVisitor,
    ApplicabilityVisitor {
        private ClassInstanceCreation primitiveTypeCreation = null;

        protected PrimitiveTypeCreationFinder() {
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.primitiveTypeCreation == null) {
                if (!this.isPrimitiveTypeCreation(node)) {
                    return true;
                }
                this.primitiveTypeCreation = node;
            }
            return false;
        }

        public ClassInstanceCreation getPrimitiveTypeCreation() {
            return this.primitiveTypeCreation;
        }

        private boolean isPrimitiveTypeCreation(ClassInstanceCreation node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            return primitiveWrapperClasses.contains(typeBinding.getQualifiedName());
        }

        @Override
        public String getLabelReplacement() {
            if (this.primitiveTypeCreation == null || this.primitiveTypeCreation.arguments().isEmpty()) {
                return "...";
            }
            return this.primitiveTypeCreation.arguments().get(0).toString();
        }

        @Override
        public boolean isApplicable() {
            return this.primitiveTypeCreation != null && (!UseValueOfResolution.this.isFloatingPoint || UseValueOfResolution.this.isDouble == "java.lang.Double".equals(this.primitiveTypeCreation.resolveTypeBinding().getQualifiedName()));
        }
    }
}

