/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.QuickFixContribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class QuickFixesExtensionHelper {
    private static final String EXTENSION_POINT_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsQuickFixes";
    private static final String ARGUMENTS = "arguments";
    private static final String PATTERN = "pattern";
    private static final String LABEL = "label";
    private static final String CLASS_FQN = "class";
    private static Map<String, List<QuickFixContribution>> contributedQuickFixes;

    /*
     * WARNING - void declaration
     */
    public static synchronized Map<String, List<QuickFixContribution>> getContributedQuickFixes() {
        void var6_8;
        IExtension[] extensions;
        if (contributedQuickFixes != null) {
            return contributedQuickFixes;
        }
        HashMap<String, List<QuickFixContribution>> set = new HashMap<String, List<QuickFixContribution>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            return Collections.EMPTY_MAP;
        }
        IExtension[] arr$ = extensions = point.getExtensions();
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            IConfigurationElement[] elements;
            IExtension extension = arr$[var6_8];
            for (IConfigurationElement configElt : elements = extension.getConfigurationElements()) {
                QuickFixesExtensionHelper.addContribution(set, configElt);
            }
            ++var6_8;
        }
        Set entrySet = set.entrySet();
        for (Map.Entry entry : entrySet) {
            entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
        }
        contributedQuickFixes = Collections.unmodifiableMap(set);
        return contributedQuickFixes;
    }

    private static void addContribution(Map<String, List<QuickFixContribution>> set, IConfigurationElement configElt) {
        IContributor contributor = null;
        try {
            HashSet<String> args;
            contributor = configElt.getContributor();
            if (contributor == null) {
                throw new IllegalArgumentException("Null contributor");
            }
            String clazzFqn = configElt.getAttribute(CLASS_FQN);
            if (QuickFixesExtensionHelper.isEmpty(clazzFqn)) {
                throw new IllegalArgumentException("Missing 'class' attribute");
            }
            String label = configElt.getAttribute(LABEL);
            if (QuickFixesExtensionHelper.isEmpty(label)) {
                throw new IllegalArgumentException("Missing 'label' attribute");
            }
            String pattern = configElt.getAttribute(PATTERN);
            if (QuickFixesExtensionHelper.isEmpty(pattern)) {
                throw new IllegalArgumentException("Missing 'pattern' attribute");
            }
            String arg = configElt.getAttribute(ARGUMENTS);
            if (arg == null) {
                args = Collections.EMPTY_SET;
            } else {
                String[] strings = arg.split(",\\s*");
                args = new HashSet<String>();
                for (String string : strings) {
                    args.add(string);
                }
            }
            QuickFixContribution qf = QuickFixesExtensionHelper.createQuickFix(configElt, clazzFqn, label, pattern, args);
            List<QuickFixContribution> list = set.get(pattern);
            if (list == null) {
                list = new ArrayList<QuickFixContribution>();
                set.put(pattern, list);
            }
            if (list.contains(qf)) {
                throw new IllegalArgumentException("Duplicated quick fix contribution for pattern '" + pattern + "': " + qf + ".");
            }
            list.add(qf);
        }
        catch (Throwable e) {
            String cName = contributor != null ? contributor.getName() : "unknown contributor";
            String message = "Failed to read contribution for 'edu.umd.cs.findbugs.plugin.eclipse.findbugsQuickFixes' extension point from " + cName;
            FindbugsPlugin.getDefault().logException(e, message);
        }
    }

    private static QuickFixContribution createQuickFix(final IConfigurationElement configElt, String clazzFqn, String label, String pattern, Set<String> args) {
        return new QuickFixContribution(clazzFqn, label, pattern, args, new Callable<BugResolution>(){

            @Override
            public BugResolution call() throws Exception {
                return (BugResolution)((Object)configElt.createExecutableExtension(QuickFixesExtensionHelper.CLASS_FQN));
            }
        });
    }

    static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

