/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class SourceLineAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROLE = "SOURCE_LINE_DEFAULT";
    public static final String DEFAULT_ROLE_UNKNOWN_LINE = "SOURCE_LINE_DEFAULT_UNKNOWN_LINE";
    public static final String ROLE_ANOTHER_INSTANCE = "SOURCE_LINE_ANOTHER_INSTANCE";
    public static final String ROLE_CALLED_FROM_SUPERCLASS_AT = "SOURCE_LINE_CALLED_FROM_SUPERCLASS_AT";
    public static final String ROLE_FIELD_SET_TOO_LATE_AT = "SOURCE_LINE_FIELD_SET_TOO_LATE_AT";
    public static final String ROLE_GENERATED_AT = "SOURCE_LINE_GENERATED_AT";
    public static final String ROLE_OBLIGATION_CREATED = "SOURCE_LINE_OBLIGATION_CREATED";
    public static final String ROLE_OBLIGATION_CREATED_BY_WILLCLOSE_PARAMETER = "SOURCE_LINE_OBLIGATION_CREATED_BY_WILLCLOSE_PARAMETER";
    public static final String ROLE_PATH_CONTINUES = "SOURCE_LINE_PATH_CONTINUES";
    public static final String ROLE_LOCK_OBTAINED_AT = "SOURCE_LINE_LOCK_OBTAINED_AT";
    public static final String ROLE_UNREACHABLE_CODE = "SOURCE_UNREACHABLE_CODE";
    public static final String UNKNOWN_SOURCE_FILE = "<Unknown>";
    public static final char CANONICAL_PACKAGE_SEPARATOR = '/';
    private String description;
    @DottedClassName
    private final String className;
    private String sourceFile;
    private final int startLine;
    private final int endLine;
    private final int startBytecode;
    private final int endBytecode;
    private boolean synthetic;
    public static final String DESCRIPTION_LAST_CHANGE = "SOURCE_LINE_LAST_CHANGE";
    public static final String DESCRIPTION_LOOP_BOTTOM = "SOURCE_LINE_LOOP_BOTTOM";
    static final ThreadLocal<Project> myProject = new ThreadLocal();
    static final ThreadLocal<String> relativeSourceBase = new ThreadLocal();
    private static final String ELEMENT_NAME = "SourceLine";

    public SourceLineAnnotation(@Nonnull @DottedClassName String className, @Nonnull String sourceFile, int startLine, int endLine, int startBytecode, int endBytecode) {
        Objects.requireNonNull(className, "class name is null");
        Objects.requireNonNull(sourceFile, "source file is null");
        this.description = DEFAULT_ROLE;
        this.className = className;
        this.sourceFile = sourceFile;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startBytecode = startBytecode;
        this.endBytecode = endBytecode;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SourceLineAnnotation createUnknown(@DottedClassName String className, String sourceFile) {
        return SourceLineAnnotation.createUnknown(className, sourceFile, -1, -1);
    }

    public static SourceLineAnnotation createUnknown(@DottedClassName String className) {
        return SourceLineAnnotation.createUnknown(className, AnalysisContext.currentAnalysisContext().lookupSourceFile(className), -1, -1);
    }

    public static SourceLineAnnotation createReallyUnknown(@DottedClassName String className) {
        return SourceLineAnnotation.createUnknown(className, UNKNOWN_SOURCE_FILE, -1, -1);
    }

    @Nonnull
    public static SourceLineAnnotation createUnknown(@DottedClassName String className, String sourceFile, int startBytecode, int endBytecode) {
        SourceLineAnnotation result = new SourceLineAnnotation(className, sourceFile, -1, -1, startBytecode, endBytecode);
        return result;
    }

    public static SourceLineAnnotation fromVisitedMethod(PreorderVisitor visitor) {
        SourceLineAnnotation sourceLines = SourceLineAnnotation.getSourceAnnotationForMethod(visitor.getDottedClassName(), visitor.getMethodName(), visitor.getMethodSig());
        return sourceLines;
    }

    public static SourceLineAnnotation fromVisitedMethod(MethodGen methodGen, String sourceFile) {
        LineNumberTable lineNumberTable = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        int codeSize = methodGen.getInstructionList().getLength();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, 0, codeSize - 1);
        }
        return SourceLineAnnotation.forEntireMethod(className, sourceFile, lineNumberTable, codeSize);
    }

    public static SourceLineAnnotation forEntireMethod(@DottedClassName String className, String sourceFile, LineNumberTable lineNumberTable, int codeSize) {
        LineNumber[] table = lineNumberTable.getLineNumberTable();
        if (table != null && table.length > 0) {
            LineNumber first = table[0];
            LineNumber last = table[table.length - 1];
            return new SourceLineAnnotation(className, sourceFile, first.getLineNumber(), last.getLineNumber(), 0, codeSize - 1);
        }
        return SourceLineAnnotation.createUnknown(className, sourceFile, 0, codeSize - 1);
    }

    public static SourceLineAnnotation forEntireMethod(JavaClass javaClass, @CheckForNull Method method) {
        String sourceFile = javaClass.getSourceFileName();
        if (method == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), sourceFile);
        }
        Code code = method.getCode();
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        if (code == null || lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), sourceFile);
        }
        return SourceLineAnnotation.forEntireMethod(javaClass.getClassName(), sourceFile, lineNumberTable, code.getLength());
    }

    public static SourceLineAnnotation forEntireMethod(JavaClass javaClass, XMethod xmethod) {
        JavaClassAndMethod m = Hierarchy.findMethod(javaClass, xmethod.getName(), xmethod.getSignature());
        if (m == null) {
            return SourceLineAnnotation.createUnknown(javaClass.getClassName(), javaClass.getSourceFileName());
        }
        return SourceLineAnnotation.forEntireMethod(javaClass, m.getMethod());
    }

    public static SourceLineAnnotation forFirstLineOfMethod(MethodDescriptor methodDescriptor) {
        SourceLineAnnotation result = null;
        try {
            Method m = Global.getAnalysisCache().getMethodAnalysis(Method.class, methodDescriptor);
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, methodDescriptor.getClassDescriptor());
            LineNumberTable lnt = m.getLineNumberTable();
            String sourceFile = xclass.getSource();
            if (sourceFile != null && lnt != null) {
                LineNumber[] entries;
                int firstLine = Integer.MAX_VALUE;
                int bytecode = 0;
                for (LineNumber entry : entries = lnt.getLineNumberTable()) {
                    if (entry.getLineNumber() >= firstLine) continue;
                    firstLine = entry.getLineNumber();
                    bytecode = entry.getStartPC();
                }
                if (firstLine < Integer.MAX_VALUE) {
                    result = new SourceLineAnnotation(methodDescriptor.getClassDescriptor().toDottedClassName(), sourceFile, firstLine, firstLine, bytecode, bytecode);
                }
            }
        }
        catch (CheckedAnalysisException checkedAnalysisException) {
            // empty catch block
        }
        if (result == null) {
            result = SourceLineAnnotation.createUnknown(methodDescriptor.getClassDescriptor().toDottedClassName());
        }
        return result;
    }

    public static SourceLineAnnotation fromVisitedInstruction(BytecodeScanningDetector visitor, int pc) {
        return SourceLineAnnotation.fromVisitedInstructionRange(visitor.getClassContext(), visitor, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, PreorderVisitor visitor, int pc) {
        return SourceLineAnnotation.fromVisitedInstructionRange(classContext, visitor, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, Location loc) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext, method, loc.getHandle());
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, InstructionHandle handle) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext, method, handle.getPosition());
    }

    public static SourceLineAnnotation fromVisitedInstruction(MethodDescriptor methodDescriptor, Location location) {
        return SourceLineAnnotation.fromVisitedInstruction(methodDescriptor, location.getHandle().getPosition());
    }

    public static SourceLineAnnotation fromVisitedInstruction(MethodDescriptor methodDescriptor, int position) {
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, methodDescriptor.getClassDescriptor());
            Method method = analysisCache.getMethodAnalysis(Method.class, methodDescriptor);
            return SourceLineAnnotation.fromVisitedInstruction(jclass, method, position);
        }
        catch (CheckedAnalysisException e) {
            return SourceLineAnnotation.createReallyUnknown(methodDescriptor.getClassDescriptor().toDottedClassName());
        }
    }

    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, Method method, int pc) {
        return SourceLineAnnotation.fromVisitedInstruction(classContext.getJavaClass(), method, pc);
    }

    public static SourceLineAnnotation fromVisitedInstruction(JavaClass jclass, Method method, int pc) {
        LineNumberTable lineNumberTable = method.getCode().getLineNumberTable();
        String className = jclass.getClassName();
        String sourceFile = jclass.getSourceFileName();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, pc, pc);
        }
        int startLine = lineNumberTable.getSourceLine(pc);
        return new SourceLineAnnotation(className, sourceFile, startLine, startLine, pc, pc);
    }

    public static SourceLineAnnotation fromVisitedInstructionRange(BytecodeScanningDetector visitor, int startPC, int endPC) {
        LineNumberTable lineNumberTable = SourceLineAnnotation.getLineNumberTable(visitor);
        String className = visitor.getDottedClassName();
        String sourceFile = visitor.getSourceFile();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        int startLine = lineNumberTable.getSourceLine(startPC);
        int endLine = lineNumberTable.getSourceLine(endPC);
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    @Nonnull
    public static SourceLineAnnotation fromVisitedInstructionRange(ClassContext classContext, PreorderVisitor visitor, int startPC, int endPC) {
        if (startPC > endPC) {
            throw new IllegalArgumentException("Start pc " + startPC + " greater than end pc " + endPC);
        }
        LineNumberTable lineNumberTable = SourceLineAnnotation.getLineNumberTable(visitor);
        String className = visitor.getDottedClassName();
        String sourceFile = visitor.getSourceFile();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        int startLine = lineNumberTable.getSourceLine(startPC);
        int endLine = lineNumberTable.getSourceLine(endPC);
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    public static SourceLineAnnotation fromRawData(String className, String sourceFile, int startLine, int endLine, int startPC, int endPC) {
        if (startLine == -1) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, startPC, endPC);
        }
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, startPC, endPC);
    }

    public static SourceLineAnnotation fromVisitedInstruction(BytecodeScanningDetector visitor) {
        return SourceLineAnnotation.fromVisitedInstruction(visitor.getClassContext(), visitor, visitor.getPC());
    }

    @Nonnull
    public static SourceLineAnnotation fromVisitedInstruction(ClassContext classContext, MethodGen methodGen, String sourceFile, @Nonnull InstructionHandle handle) {
        LineNumberTable table = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        int bytecodeOffset = handle.getPosition();
        if (table == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, bytecodeOffset, bytecodeOffset);
        }
        int lineNumber = table.getSourceLine(handle.getPosition());
        return new SourceLineAnnotation(className, sourceFile, lineNumber, lineNumber, bytecodeOffset, bytecodeOffset);
    }

    public static SourceLineAnnotation fromVisitedInstructionRange(ClassContext classContext, MethodGen methodGen, String sourceFile, InstructionHandle start, InstructionHandle end) {
        LineNumberTable lineNumberTable = methodGen.getLineNumberTable(methodGen.getConstantPool());
        String className = methodGen.getClassName();
        if (lineNumberTable == null) {
            return SourceLineAnnotation.createUnknown(className, sourceFile, start.getPosition(), end.getPosition());
        }
        int startLine = lineNumberTable.getSourceLine(start.getPosition());
        int endLine = lineNumberTable.getSourceLine(end.getPosition());
        return new SourceLineAnnotation(className, sourceFile, startLine, endLine, start.getPosition(), end.getPosition());
    }

    private static LineNumberTable getLineNumberTable(PreorderVisitor visitor) {
        Code code = visitor.getMethod().getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    @Nonnull
    @DottedClassName
    public String getClassName() {
        return this.className;
    }

    @Nonnull
    public String getSourceFile() {
        return this.sourceFile;
    }

    public boolean isSourceFileKnown() {
        return !UNKNOWN_SOURCE_FILE.equals(this.sourceFile);
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSimpleClassName() {
        int lastDot = this.className.lastIndexOf(46);
        return this.className.substring(lastDot + 1);
    }

    public String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return this.className.substring(0, lastDot);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartBytecode() {
        return this.startBytecode;
    }

    public int getEndBytecode() {
        return this.endBytecode;
    }

    public boolean isUnknown() {
        return this.startLine < 0 || this.endLine < 0;
    }

    @Override
    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitSourceLineAnnotation(this);
    }

    @Override
    public String format(String key, ClassAnnotation primaryClass) {
        if ("hash".equals(key)) {
            return "";
        }
        if ("".equals(key)) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.sourceFile);
            this.appendLines(buf);
            return buf.toString();
        }
        if ("lineNumber".equals(key)) {
            StringBuilder buf = new StringBuilder();
            this.appendLinesRaw(buf);
            return buf.toString();
        }
        if ("full".equals(key)) {
            StringBuilder buf = new StringBuilder();
            String pkgName = this.getPackageName();
            if (!"".equals(pkgName)) {
                buf.append(pkgName.replace('.', '/'));
                buf.append('/');
            }
            buf.append(this.sourceFile);
            this.appendLines(buf);
            return buf.toString();
        }
        throw new IllegalArgumentException("Unknown format key " + key);
    }

    private void appendLines(StringBuilder buf) {
        if (this.isUnknown()) {
            return;
        }
        buf.append(":[");
        this.appendLinesRaw(buf);
        buf.append(']');
    }

    private void appendLinesRaw(StringBuilder buf) {
        if (this.isUnknown()) {
            return;
        }
        if (this.startLine == this.endLine) {
            buf.append("line ");
            buf.append(this.startLine);
        } else {
            buf.append("lines ");
            buf.append(this.startLine);
            buf.append('-');
            buf.append(this.endLine);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description.intern();
    }

    public String toString() {
        String desc = this.description;
        if (DEFAULT_ROLE.equals(desc) && this.isUnknown()) {
            desc = DEFAULT_ROLE_UNKNOWN_LINE;
        }
        String pattern = I18N.instance().getAnnotationDescription(desc);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    @Override
    public int compareTo(BugAnnotation o) {
        if (!(o instanceof SourceLineAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        SourceLineAnnotation other = (SourceLineAnnotation)o;
        int cmp = this.className.compareTo(other.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.startLine - other.startLine;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.endLine - other.endLine;
        if (this.startLine != -1) {
            return 0;
        }
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.startBytecode - other.startBytecode;
        if (cmp != 0) {
            return cmp;
        }
        return this.endBytecode - other.endBytecode;
    }

    public int hashCode() {
        if (this.startLine != -1) {
            return this.className.hashCode() + this.startLine + 3 * this.endLine + this.getDescription().hashCode();
        }
        return this.className.hashCode() + this.startBytecode + 3 * this.endBytecode + this.getDescription().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceLineAnnotation)) {
            return false;
        }
        SourceLineAnnotation other = (SourceLineAnnotation)o;
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.startLine != -1) {
            return this.className.equals(other.className) && this.startLine == other.startLine && this.endLine == other.endLine;
        }
        return this.className.equals(other.className) && this.startBytecode == other.startBytecode && this.endBytecode == other.endBytecode;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public static void generateRelativeSource(File relativeSourceBase, Project project) {
        try {
            SourceLineAnnotation.relativeSourceBase.set(relativeSourceBase.getCanonicalPath());
            myProject.set(project);
        }
        catch (IOException e) {
            AnalysisContext.logError("Error resolving relative source base " + relativeSourceBase, e);
        }
    }

    public static void clearGenerateRelativeSource() {
        myProject.remove();
        relativeSourceBase.remove();
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        String role;
        int n;
        String classname = this.getClassName();
        String sourcePath = this.getSourcePath();
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", classname);
        if (isPrimary) {
            attributeList.addAttribute("primary", "true");
        }
        if ((n = this.getStartLine()) >= 0) {
            attributeList.addAttribute("start", String.valueOf(n));
        }
        if ((n = this.getEndLine()) >= 0) {
            attributeList.addAttribute("end", String.valueOf(n));
        }
        if ((n = this.getStartBytecode()) >= 0) {
            attributeList.addAttribute("startBytecode", String.valueOf(n));
        }
        if ((n = this.getEndBytecode()) >= 0) {
            attributeList.addAttribute("endBytecode", String.valueOf(n));
        }
        if (this.isSourceFileKnown()) {
            attributeList.addAttribute("sourcefile", this.sourceFile);
            attributeList.addAttribute("sourcepath", sourcePath);
            Project project = myProject.get();
            if (project != null) {
                try {
                    SourceFinder mySourceFinder = project.getSourceFinder();
                    String fullPath = new File(mySourceFinder.findSourceFile(this).getFullFileName()).getCanonicalPath();
                    String myRelativeSourceBase = relativeSourceBase.get();
                    if (fullPath.startsWith(myRelativeSourceBase) && fullPath.length() > myRelativeSourceBase.length()) {
                        attributeList.addAttribute("relSourcepath", fullPath.substring(myRelativeSourceBase.length() + 1));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (!DEFAULT_ROLE.equals(role = this.getDescription())) {
            attributeList.addAttribute("role", this.getDescription());
        }
        if (this.synthetic) {
            attributeList.addAttribute("synthetic", "true");
        }
        if (addMessages) {
            xmlOutput.openTag(ELEMENT_NAME, attributeList);
            xmlOutput.openTag("Message");
            xmlOutput.writeText(this.toString());
            xmlOutput.closeTag("Message");
            xmlOutput.closeTag(ELEMENT_NAME);
        } else {
            xmlOutput.openCloseTag(ELEMENT_NAME, attributeList);
        }
    }

    public String getSourcePath() {
        String classname = this.getClassName();
        String packageName = "";
        if (classname.indexOf(46) > 0) {
            packageName = classname.substring(0, 1 + classname.lastIndexOf(46));
        }
        String sourcePath = packageName.replace('.', '/') + this.sourceFile;
        return sourcePath;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public boolean isSignificant() {
        return false;
    }

    static SourceLineAnnotation getSourceAnnotationForMethod(String className, String methodName, String methodSig) {
        JavaClassAndMethod targetMethod = null;
        Code code = null;
        try {
            Method method;
            JavaClass targetClass = AnalysisContext.currentAnalysisContext().lookupClass(className);
            targetMethod = Hierarchy.findMethod(targetClass, methodName, methodSig);
            if (targetMethod != null && (method = targetMethod.getMethod()) != null) {
                code = method.getCode();
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        SourceInfoMap sourceInfoMap = AnalysisContext.currentAnalysisContext().getSourceInfoMap();
        SourceInfoMap.SourceLineRange range = sourceInfoMap.getMethodLine(className, methodName, methodSig);
        if (range != null) {
            return new SourceLineAnnotation(className, AnalysisContext.currentAnalysisContext().lookupSourceFile(className), range.getStart(), range.getEnd(), 0, code == null ? -1 : code.getLength());
        }
        if (sourceInfoMap.fallBackToClassfile() && targetMethod != null) {
            return SourceLineAnnotation.forEntireMethod(targetMethod.getJavaClass(), targetMethod.getMethod());
        }
        return SourceLineAnnotation.createUnknown(className);
    }

    static SourceLineAnnotation getSourceAnnotationForClass(String className, String sourceFileName) {
        int lastLine = -1;
        int firstLine = Integer.MAX_VALUE;
        try {
            JavaClass targetClass = AnalysisContext.currentAnalysisContext().lookupClass(className);
            for (Method m : targetClass.getMethods()) {
                LineNumberTable table;
                Code c = m.getCode();
                if (c == null || (table = c.getLineNumberTable()) == null) continue;
                for (LineNumber line : table.getLineNumberTable()) {
                    lastLine = Math.max(lastLine, line.getLineNumber());
                    firstLine = Math.min(firstLine, line.getLineNumber());
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if (firstLine < Integer.MAX_VALUE) {
            return new SourceLineAnnotation(className, sourceFileName, firstLine, lastLine, -1, -1);
        }
        return SourceLineAnnotation.createUnknown(className, sourceFileName);
    }

    @Override
    public String toString(ClassAnnotation primaryClass) {
        return this.toString();
    }
}

