/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.view.explorer.GroupType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;

public class Grouping {
    private final LinkedList<GroupType> groupOrder;

    private Grouping(List<GroupType> types) {
        this.groupOrder = new LinkedList<GroupType>(types);
        if (!this.groupOrder.contains((Object)GroupType.Marker)) {
            this.groupOrder.add(GroupType.Marker);
        }
    }

    private static Grouping createDefault() {
        ArrayList<GroupType> order = new ArrayList<GroupType>();
        order.add(GroupType.Project);
        order.add(GroupType.BugRank);
        order.add(GroupType.Confidence);
        order.add(GroupType.Pattern);
        order.add(GroupType.Marker);
        return Grouping.createFrom(order);
    }

    @Nonnull
    public static Grouping createFrom(List<GroupType> types) {
        return new Grouping(types);
    }

    @Nonnull
    public List<GroupType> asList() {
        return new LinkedList<GroupType>(this.groupOrder);
    }

    @Nonnull
    public GroupType getFirstType() {
        return this.groupOrder.size() > 0 ? this.groupOrder.getFirst() : GroupType.Undefined;
    }

    @Nonnull
    public GroupType getChildType(GroupType parent) {
        if (parent == GroupType.Marker) {
            return parent;
        }
        for (int i = 0; i < this.groupOrder.size(); ++i) {
            if (this.groupOrder.get(i) != parent) continue;
            return i + 1 < this.groupOrder.size() ? this.groupOrder.get(i + 1) : GroupType.Marker;
        }
        return GroupType.Marker;
    }

    Iterator<GroupType> iterator() {
        return this.groupOrder.iterator();
    }

    public GroupType getParentType(GroupType child) {
        for (int i = 0; i < this.groupOrder.size(); ++i) {
            if (this.groupOrder.get(i) != child) continue;
            return i - 1 >= 0 ? this.groupOrder.get(i - 1) : GroupType.Undefined;
        }
        return GroupType.Undefined;
    }

    static Grouping restoreFrom(String saved) {
        if (saved == null || saved.length() == 0) {
            return Grouping.createDefault();
        }
        StringTokenizer st = new StringTokenizer(saved, "[] ,", false);
        ArrayList<GroupType> types = new ArrayList<GroupType>();
        while (st.hasMoreTokens()) {
            GroupType type = GroupType.getType(st.nextToken());
            types.add(type);
        }
        if (types.isEmpty()) {
            return Grouping.createDefault();
        }
        return Grouping.createFrom(types);
    }

    public boolean contains(GroupType type) {
        return this.groupOrder.contains((Object)type);
    }

    int compare(GroupType g1, GroupType g2) {
        return this.groupOrder.indexOf((Object)g1) - this.groupOrder.indexOf((Object)g2);
    }

    public String toString() {
        return this.groupOrder.toString();
    }
}

