/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.explorer.GroupType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class GroupSelectionDialog
extends SelectionDialog {
    private final List<GroupType> allowedGroups;
    private final List<GroupType> preSelectedGroups;
    private final Map<GroupType, Boolean> selectionMap;
    private CheckboxTableViewer checkList;
    private Button upButton;
    private Button downButton;

    public GroupSelectionDialog(Shell parentShell, List<GroupType> selectedGroups) {
        super(parentShell);
        this.preSelectedGroups = selectedGroups;
        this.allowedGroups = GroupType.getVisible();
        this.selectionMap = new HashMap<GroupType, Boolean>();
        this.initSelections();
    }

    private void initSelections() {
        Collections.reverse(this.preSelectedGroups);
        for (GroupType type : this.preSelectedGroups) {
            if (!this.allowedGroups.remove((Object)type)) continue;
            this.allowedGroups.add(0, type);
        }
        Collections.reverse(this.preSelectedGroups);
        for (GroupType groupType : this.allowedGroups) {
            this.selectionMap.put(groupType, this.preSelectedGroups.contains((Object)groupType));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int columns = 2;
        composite.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 200;
        layoutData.minimumWidth = 250;
        layoutData.heightHint = 200;
        layoutData.widthHint = 250;
        composite.setLayoutData((Object)layoutData);
        this.checkList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2836);
        Table table = this.checkList.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText("Group Visibility / Sort Order");
        nameColumn.setResizable(true);
        nameColumn.setWidth(170);
        this.checkList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkList.setInput(this.allowedGroups);
        this.checkList.setCheckedElements(this.preSelectedGroups.toArray());
        this.checkList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                GroupType element = (GroupType)((Object)event.getElement());
                GroupSelectionDialog.this.selectionMap.put(element, checked);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupSelectionDialog.this.handleTableSelection();
            }
        });
        this.createButtonList(composite);
        return composite;
    }

    private void createButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.upButton = new Button(composite, 0x1000008);
        this.upButton.setText("Up");
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GroupSelectionDialog.this.getSelectionIndex();
                if (index != -1) {
                    GroupSelectionDialog.this.moveUp((GroupType)((Object)GroupSelectionDialog.this.allowedGroups.get(index)));
                    GroupSelectionDialog.this.checkList.refresh();
                    GroupSelectionDialog.this.handleTableSelection();
                }
            }
        });
        GridData data = new GridData();
        data.widthHint = 50;
        data.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)data);
        this.downButton = new Button(composite, 0x1000008);
        this.downButton.setText("Down");
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GroupSelectionDialog.this.getSelectionIndex();
                if (index != -1) {
                    GroupSelectionDialog.this.moveDown((GroupType)((Object)GroupSelectionDialog.this.allowedGroups.get(index)));
                    GroupSelectionDialog.this.checkList.refresh();
                    GroupSelectionDialog.this.handleTableSelection();
                }
            }
        });
        data = new GridData();
        data.widthHint = 50;
        data.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)data);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings dialogSettings = FindbugsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("GroupSelectionDialog");
        if (section == null) {
            dialogSettings.addNewSection("GroupSelectionDialog");
        }
        return section;
    }

    void moveUp(GroupType type) {
        int indexOf = this.allowedGroups.indexOf((Object)type);
        this.allowedGroups.remove(indexOf);
        this.allowedGroups.add(indexOf - 1, type);
    }

    void moveDown(GroupType type) {
        int indexOf = this.allowedGroups.indexOf((Object)type);
        this.allowedGroups.remove(indexOf);
        this.allowedGroups.add(indexOf + 1, type);
    }

    private void handleTableSelection() {
        GroupType item = this.getSelectedItem();
        if (item != null) {
            int index = this.getSelectionIndex();
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < this.allowedGroups.size() - 1);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private GroupType getSelectedItem() {
        return (GroupType)((Object)((IStructuredSelection)this.checkList.getSelection()).getFirstElement());
    }

    private int getSelectionIndex() {
        return this.checkList.getTable().getSelectionIndex();
    }

    public List<GroupType> getGroups() {
        ArrayList<GroupType> selected = new ArrayList<GroupType>();
        for (GroupType groupType : this.allowedGroups) {
            if (!this.selectionMap.get((Object)groupType).booleanValue()) continue;
            selected.add(groupType);
        }
        return selected;
    }
}

