/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.Grouping;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class BugLabelProvider
implements ICommonLabelProvider,
IColorProvider {
    private final WorkbenchLabelProvider wbProvider = new WorkbenchLabelProvider();
    private BugContentProvider provider;

    @CheckForNull
    public Image getImage(Object element) {
        if (element instanceof BugGroup) {
            BugGroup group = (BugGroup)element;
            switch (group.getType()) {
                case Class: 
                case Package: 
                case Project: 
                case Marker: {
                    return this.wbProvider.getImage(group.getData());
                }
                case BugRank: {
                    FindBugsMarker.MarkerRank rank = (FindBugsMarker.MarkerRank)((Object)group.getData());
                    if (rank == null) {
                        return null;
                    }
                    ImageRegistry imageRegistry = FindbugsPlugin.getDefault().getImageRegistry();
                    return imageRegistry.get(rank.iconName());
                }
                case Confidence: {
                    FindBugsMarker.MarkerConfidence markerConfidence = (FindBugsMarker.MarkerConfidence)((Object)group.getData());
                    if (markerConfidence == null) {
                        return null;
                    }
                    ImageRegistry imageRegistry = FindbugsPlugin.getDefault().getImageRegistry();
                    return imageRegistry.get(markerConfidence.iconName());
                }
            }
            ImageRegistry imageRegistry = FindbugsPlugin.getDefault().getImageRegistry();
            return imageRegistry.get("buggy-tiny-gray.png");
        }
        if (element instanceof IMarker && !((IMarker)element).exists()) {
            return null;
        }
        return this.wbProvider.getImage(element);
    }

    boolean isStandalone() {
        return this.provider == null;
    }

    public String getText(Object element) {
        IMarker marker;
        if (element instanceof BugGroup) {
            BugGroup group = (BugGroup)element;
            String cloudName = null;
            Object data = group.getData();
            if (group.getType() == GroupType.Project && data != null) {
                try {
                    SortedBugCollection bc = FindbugsPlugin.getBugCollection((IProject)data, null);
                    Cloud cloud = bc.getCloud();
                    if (cloud.isOnlineCloud()) {
                        cloudName = cloud.getCloudName();
                    }
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Failed to load bug collection");
                }
            }
            if (this.isStandalone()) {
                return group.getShortDescription();
            }
            int filtered = this.getFilteredMarkersCount(group);
            String filterCount = filtered > 0 ? "/" + filtered + " filtered" : "";
            String str = group.getShortDescription() + " (" + (group.getMarkersCount() - filtered) + filterCount + ")";
            if (cloudName != null) {
                str = str + " - " + cloudName;
            }
            return str;
        }
        if (element instanceof IMarker && !(marker = (IMarker)element).exists()) {
            return null;
        }
        if (element instanceof IStructuredSelection) {
            return this.getDescriptionAndBugCount(((IStructuredSelection)element).toArray());
        }
        if (element instanceof Object[]) {
            return this.getDescriptionAndBugCount((Object[])element);
        }
        return this.wbProvider.getText(element);
    }

    private int getFilteredMarkersCount(BugGroup group) {
        if (this.isStandalone() || !this.provider.isBugFilterActive()) {
            return 0;
        }
        return this.provider.getFilteredMarkersCount(group);
    }

    private String getDescriptionAndBugCount(Object[] objects) {
        if (objects.length == 0) {
            return "Nothing...";
        }
        if (objects.length == 1) {
            return this.getText(objects[0]);
        }
        int count = this.getBugCountsSum(objects);
        StringBuilder sb = new StringBuilder("Selection contains ");
        if (count == 1) {
            sb.append("exactly one single bug");
        } else if (count == 0) {
            sb.append("zero bugs (change filter settings to see more...)");
        } else {
            sb.append(count).append(" bugs");
        }
        if (this.isStandalone()) {
            sb.append(" (not filtered)");
        }
        return sb.toString();
    }

    private int getBugCountsSum(Object[] objects) {
        ArrayList<BugGroup> groups = new ArrayList<BugGroup>();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        for (Object object : objects) {
            if (object instanceof BugGroup) {
                groups.add((BugGroup)object);
                continue;
            }
            if (!(object instanceof IMarker)) continue;
            markers.add((IMarker)object);
        }
        if (groups.size() > 1 && !this.isStandalone()) {
            Collections.sort(groups, new Comparator<BugGroup>(){
                Grouping grouping;
                {
                    this.grouping = BugLabelProvider.this.getGrouping();
                }

                @Override
                public int compare(BugGroup o1, BugGroup o2) {
                    return this.grouping.compare(o1.getType(), o2.getType());
                }
            });
        }
        HashSet<BugGroup> finalGroups = new HashSet<BugGroup>();
        int count = 0;
        while (!groups.isEmpty()) {
            BugGroup g1 = (BugGroup)groups.remove(groups.size() - 1);
            boolean keepIt = true;
            for (BugGroup g2 : groups) {
                Object parent = g1.getParent();
                while (g2 != parent && parent instanceof BugGroup) {
                    parent = ((BugGroup)parent).getParent();
                }
                if (g2 != parent) continue;
                keepIt = false;
                break;
            }
            if (!keepIt) continue;
            finalGroups.add(g1);
            count += g1.getMarkersCount() - this.getFilteredMarkersCount(g1);
        }
        while (!markers.isEmpty()) {
            IMarker marker = (IMarker)markers.remove(markers.size() - 1);
            boolean keepIt = true;
            for (BugGroup group : finalGroups) {
                if (!group.contains(marker)) continue;
                keepIt = false;
                break;
            }
            if (!keepIt) continue;
            ++count;
        }
        return count;
    }

    public void init(ICommonContentExtensionSite config) {
        this.provider = BugContentProvider.getProvider(config.getService());
    }

    Grouping getGrouping() {
        return this.provider == null ? null : this.provider.getGrouping();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        BugGroup group;
        if (element instanceof BugGroup && this.getFilteredMarkersCount(group = (BugGroup)element) == group.getMarkersCount()) {
            return Display.getDefault().getSystemColor(8);
        }
        return null;
    }
}

