/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.MarkerMapper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class BugGroup
implements IAdaptable,
IActionFilter,
Comparable<BugGroup> {
    private String shortDescription;
    private final Set<Object> children;
    private Set<IMarker> allMarkers;
    @CheckForNull
    private Object parent;
    @CheckForNull
    private final Object identifier;
    @Nonnull
    private final GroupType type;

    public BugGroup(Object parent, Object identifier, @Nonnull GroupType type) {
        this.parent = parent;
        Assert.isNotNull((Object)((Object)type), (String)"Group type cannot be null");
        this.type = type;
        this.identifier = identifier;
        this.children = new HashSet<Object>();
        this.allMarkers = new HashSet<IMarker>();
        if (parent instanceof BugGroup) {
            BugGroup bugGroup = (BugGroup)parent;
            bugGroup.addChild(this);
        }
    }

    public Object[] getChildren() {
        if (this.children.size() == 0) {
            return this.allMarkers.toArray(new Object[this.allMarkers.size()]);
        }
        return this.children.toArray(new Object[this.children.size()]);
    }

    public Set<IMarker> getAllMarkers() {
        return this.allMarkers;
    }

    public boolean contains(Object elt) {
        if (elt instanceof IMarker) {
            return this.allMarkers.contains(elt);
        }
        return this.children.contains(elt);
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            switch (this.type) {
                case Marker: {
                    break;
                }
                case Workspace: {
                    return "Overall issues number: ";
                }
                case WorkingSet: {
                    return "Overall issues number: ";
                }
                default: {
                    MarkerMapper<?> mapper = this.type.getMapper();
                    this.shortDescription = this.identifier == null ? mapper.getShortDescription(this) : mapper.getShortDescription(this.identifier);
                }
            }
        }
        return this.shortDescription;
    }

    public Object getParent() {
        return this.parent;
    }

    public int size() {
        return this.children.size();
    }

    public int getMarkersCount() {
        return this.allMarkers.size();
    }

    void addChild(Object child) {
        this.children.add(child);
        if (BugContentProvider.DEBUG) {
            System.out.println("Adding child: " + child + " to " + this);
        }
    }

    boolean removeChild(BugGroup child) {
        boolean removed = this.children.remove(child);
        if (BugContentProvider.DEBUG) {
            System.out.println("Removing child: " + child + " from " + this);
        }
        if (this.children.size() == 0) {
            if (this.getMarkersCount() > 0) {
                this.removeMarkers(this.allMarkers);
            }
        } else {
            this.removeMarkers(child.getAllMarkers());
        }
        child.dispose();
        return removed;
    }

    void addMarker(IMarker marker) {
        boolean added = this.allMarkers.add(marker);
        if (BugContentProvider.DEBUG) {
            System.out.println("Adding marker: " + marker.getId() + " to " + this + ", new? " + added);
        }
    }

    void removeMarker(IMarker marker) {
        if (this.allMarkers.isEmpty()) {
            return;
        }
        if (BugContentProvider.DEBUG) {
            System.out.println("Removing marker: " + marker.getId() + " from " + this);
        }
        this.allMarkers.remove(marker);
        if (this.parent instanceof BugGroup) {
            ((BugGroup)this.parent).removeMarker(marker);
        }
    }

    private void removeMarkers(Set<IMarker> markers) {
        if (markers.isEmpty() || this.allMarkers.isEmpty()) {
            return;
        }
        if (BugContentProvider.DEBUG) {
            for (IMarker marker : markers) {
                System.out.println("Removing marker: " + marker.getId() + " from " + this);
            }
        }
        if (markers == this.allMarkers) {
            this.allMarkers.clear();
        } else {
            this.allMarkers.removeAll(markers);
        }
        if (this.parent instanceof BugGroup) {
            ((BugGroup)this.parent).removeMarkers(markers);
        }
    }

    void setMarkers(Set<IMarker> markers) {
        this.allMarkers = markers;
    }

    public String toString() {
        return this.shortDescription == null ? this.getShortDescription() : this.shortDescription;
    }

    public Object getAdapter(Class adapter) {
        if (this.identifier != null && adapter.isAssignableFrom(this.identifier.getClass())) {
            return this.identifier;
        }
        if (BugGroup.class == adapter) {
            return this;
        }
        if (ITaskListResourceAdapter.class == adapter) {
            return null;
        }
        return null;
    }

    @Nonnull
    public GroupType getType() {
        return this.type;
    }

    @CheckForNull
    public Object getData() {
        return this.identifier;
    }

    void dispose() {
        this.children.clear();
        this.allMarkers.clear();
        this.parent = null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if ("type".equals(name)) {
            String groupType = this.getType().name();
            boolean match = groupType.equals(value);
            if (match) {
                return match;
            }
            if (value.indexOf(124) > 0) {
                String[] split;
                for (String string : split = value.split("\\|")) {
                    if (!groupType.equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BugGroup)) {
            return false;
        }
        BugGroup bugGroup = (BugGroup)obj;
        if (!BugGroup.equals(this.parent, bugGroup.parent)) {
            return false;
        }
        if (!BugGroup.equals((Object)this.type, (Object)bugGroup.type)) {
            return false;
        }
        return BugGroup.equals(this.identifier, bugGroup.identifier);
    }

    public int hashCode() {
        if (this.identifier == null) {
            return super.hashCode();
        }
        return this.identifier.hashCode();
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1 == o2 || o1.equals(o2);
    }

    @Override
    public int compareTo(BugGroup o) {
        if (this.identifier == null || !this.getType().equals((Object)o.getType())) {
            return 0;
        }
        if (this.identifier instanceof Comparable) {
            return ((Comparable)this.identifier).compareTo(o.identifier);
        }
        return 0;
    }
}

