/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtil {
    public static final int DEFAULT_LINE_IN_EDITOR = 1;

    public static void goToLine(IEditorPart editorPart, int lineNumber) {
        if (!(editorPart instanceof ITextEditor) || lineNumber < 1) {
            return;
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (document != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (lineInfo != null) {
                editor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
            }
        }
    }
}

