/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import de.tobject.findbugs.properties.IPathElement;
import de.tobject.findbugs.properties.PathElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

abstract class PathsProvider
extends SelectionAdapter
implements IStructuredContentProvider,
ICheckStateProvider {
    private static IPath lastUsedPath;
    protected final List<IPathElement> paths;
    private final Control control;
    private final TableViewer viewer;
    protected final FindbugsPropertyPage propertyPage;
    private final ListenerList listeners;

    protected PathsProvider(TableViewer viewer, FindbugsPropertyPage propertyPage) {
        this.propertyPage = propertyPage;
        this.paths = new ArrayList<IPathElement>();
        this.viewer = viewer;
        if (viewer instanceof CheckboxTableViewer) {
            CheckboxTableViewer tv = (CheckboxTableViewer)viewer;
            tv.setCheckStateProvider((ICheckStateProvider)this);
            tv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean checked = event.getChecked();
                    IPathElement element = (IPathElement)event.getElement();
                    element.setEnabled(checked);
                    PathsProvider.this.handleContendChanged();
                }
            });
        }
        this.control = viewer.getTable();
        this.listeners = new ListenerList();
        viewer.setContentProvider((IContentProvider)this);
    }

    static void setLastUsedPath(IPath lastUsed) {
        lastUsedPath = lastUsed;
    }

    static IPath getLastUsedPath() {
        return lastUsedPath;
    }

    void setFilters(List<IPathElement> filterFiles) {
        this.paths.clear();
        this.paths.addAll(filterFiles);
        if (this.viewer instanceof CheckboxTableViewer) {
            CheckboxTableViewer tv = (CheckboxTableViewer)this.viewer;
            ArrayList<IPathElement> checked = new ArrayList<IPathElement>();
            for (IPathElement pe : this.paths) {
                if (!pe.isEnabled()) continue;
                checked.add(pe);
            }
            tv.setCheckedElements((Object[])checked.toArray(new IPathElement[checked.size()]));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        String buttonId = widget.getData() + "";
        if ("add".equals(buttonId)) {
            this.addFiles(e.display.getActiveShell());
        } else {
            Iterator selectionIter = ((IStructuredSelection)this.viewer.getSelection()).iterator();
            while (selectionIter.hasNext()) {
                this.remove((IPathElement)selectionIter.next());
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void addFiles(Shell parentShell) {
        FileDialog dialog = this.createFileDialog(parentShell);
        String pathStr = this.openFileDialog(dialog);
        if (pathStr == null) {
            return;
        }
        this.addSelectedPaths(dialog);
        this.handleContendChanged();
    }

    private FileDialog createFileDialog(Shell parentShell) {
        FileDialog dialog = new FileDialog(parentShell, 4098);
        this.configureDialog(dialog);
        IPath lastUsed = PathsProvider.getLastUsedPath();
        String filterPath = null;
        if (lastUsed != null && lastUsed.toFile().isDirectory()) {
            filterPath = lastUsed.toOSString();
            dialog.setFilterPath(filterPath);
        }
        return dialog;
    }

    protected abstract void configureDialog(FileDialog var1);

    protected String openFileDialog(FileDialog dialog) {
        return dialog.open();
    }

    protected String[] getFileNames(FileDialog dialog) {
        return dialog.getFileNames();
    }

    protected String getFilePath(FileDialog dialog) {
        return dialog.getFilterPath();
    }

    private void addSelectedPaths(FileDialog dialog) {
        String[] names = this.getFileNames(dialog);
        String filterPath = this.getFilePath(dialog);
        Path baseDir = new Path(filterPath);
        PathsProvider.setLastUsedPath((IPath)baseDir);
        for (String fileName : names) {
            IPath path = baseDir.append(fileName);
            PathElement pathElt = new PathElement(path, Status.OK_STATUS);
            if (this.paths.contains(pathElt)) continue;
            this.paths.add(pathElt);
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.paths.toArray();
    }

    public boolean isChecked(Object element) {
        if (element instanceof IPathElement) {
            IPathElement elt = (IPathElement)element;
            return elt.isEnabled();
        }
        return false;
    }

    public boolean isGrayed(Object element) {
        return false;
    }

    boolean contains(Object o) {
        return this.paths.contains(o);
    }

    void setControlEnabled(boolean enabled) {
        this.control.setEnabled(enabled);
    }

    void refresh() {
        IStatus status = this.validate();
        if (status != null) {
            this.propertyPage.setErrorMessage(status.getMessage());
        }
        this.viewer.setSelection(null);
        this.viewer.setInput(new Object());
        this.viewer.refresh(true);
    }

    protected abstract IStatus validate();

    public void remove(IPathElement holder) {
        this.paths.remove(holder);
        this.handleContendChanged();
    }

    private void handleContendChanged() {
        this.applyToPreferences();
        for (Object object : this.listeners.getListeners()) {
            ((Listener)object).handleEvent(null);
        }
    }

    protected void applyToPreferences() {
        IStatus status = this.validate();
        if (status != null) {
            this.propertyPage.setErrorMessage(status.getMessage());
        }
    }

    protected Map<String, Boolean> pathsToStrings() {
        IProject project = this.propertyPage.getProject();
        TreeMap<String, Boolean> result = new TreeMap<String, Boolean>();
        for (IPathElement path : this.paths) {
            if (path.isSystem()) {
                if (path.isEnabled()) continue;
                result.put(path.getId(), false);
                continue;
            }
            IPath filterPath = FindBugsWorker.toFilterPath(path.getPath(), project);
            result.put(filterPath.toPortableString(), path.isEnabled());
        }
        return result;
    }
}

