/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.properties.DetectorValidator;
import de.tobject.findbugs.properties.IPathElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class PathElement
implements IPathElement {
    private final IPath path;
    private IStatus status;
    private boolean enabled;
    private boolean system;

    public PathElement(IPath path, IStatus status) {
        boolean userEnabled;
        this.status = status;
        String osString = path.toOSString();
        if (!osString.contains("|")) {
            this.path = path;
            userEnabled = true;
        } else {
            String[] parts = osString.split("\\|");
            this.path = new Path(parts[0]);
            userEnabled = Boolean.parseBoolean(parts[1]);
        }
        this.enabled = userEnabled && this.path.toFile().exists();
    }

    @Override
    public void setStatus(IStatus status) {
        this.status = status;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    public String toString() {
        String id = this.getId();
        String string = this.path.toOSString();
        if (id != null) {
            string = string + " [" + id + "]";
        }
        if (this.system) {
            string = string + " (system/";
            string = this.enabled ? string + "enabled)" : string + "disabled)";
        }
        string = string + (this.status.isOK() ? "" : " (invalid entry)");
        return string;
    }

    @Override
    public String getPath() {
        return this.path.toOSString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathElement) {
            return this.path.equals((Object)((PathElement)obj).path) && this.enabled == ((PathElement)obj).enabled;
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    @Override
    public String getId() {
        if (this.status instanceof DetectorValidator.ValidationStatus) {
            DetectorValidator.ValidationStatus vs = (DetectorValidator.ValidationStatus)this.status;
            String id = vs.getSummary().id;
            if (id != null && !"?".equals(id)) {
                return id;
            }
        }
        return this.system ? this.path.toString() : null;
    }
}

