/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import de.tobject.findbugs.properties.IPathElement;
import de.tobject.findbugs.properties.ManagePathsWidget;
import de.tobject.findbugs.properties.PathElement;
import de.tobject.findbugs.properties.PathsProvider;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FilterFilesTab
extends Composite {
    private final FindbugsPropertyPage propertyPage;
    private final FilterProvider filterIncl;
    private final FilterProvider filterExcl;
    private final FilterProvider filterExclBugs;

    public FilterFilesTab(TabFolder parent, FindbugsPropertyPage page, int style) {
        super((Composite)parent, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout(2, true));
        Link label = new Link((Composite)this, 0);
        label.setText("Filter files may be used to include or exclude bug detection for particular classes and methods.\n<a href=\"http://findbugs.sourceforge.net/manual/filter.html\">Details...</a>\n");
        label.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        TabItem tabDetector = new TabItem(parent, 0);
        tabDetector.setText(FilterFilesTab.getMessage("property.filterFilesTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Configure external bug reporting filters");
        ManagePathsWidget incl = new ManagePathsWidget(this);
        CheckboxTableViewer viewer = incl.createViewer(FilterFilesTab.getMessage(FilterKind.INCLUDE.propertyName), null, true);
        this.filterIncl = this.createFilterProvider((TableViewer)viewer, FilterKind.INCLUDE, page);
        incl.createButtonsArea(this.filterIncl);
        ManagePathsWidget excl = new ManagePathsWidget(this);
        viewer = excl.createViewer(FilterFilesTab.getMessage(FilterKind.EXCLUDE.propertyName), null, true);
        this.filterExcl = this.createFilterProvider((TableViewer)viewer, FilterKind.EXCLUDE, page);
        excl.createButtonsArea(this.filterExcl);
        ManagePathsWidget excl2 = new ManagePathsWidget(this);
        viewer = excl2.createViewer(FilterFilesTab.getMessage(FilterKind.EXCLUDE_BUGS.propertyName), "You can include past FindBugs result XML files here to exclude those bugs from analysis. <a href=\"http://findbugs.sourceforge.net/manual/filter.html\">Details...</a>", true);
        this.filterExclBugs = this.createFilterProvider((TableViewer)viewer, FilterKind.EXCLUDE_BUGS, page);
        excl2.createButtonsArea(this.filterExclBugs);
        this.refreshTables();
    }

    public void refreshTables() {
        this.propertyPage.setErrorMessage(null);
        this.filterIncl.refresh();
        this.filterExcl.refresh();
        this.filterExclBugs.refresh();
    }

    protected static String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    protected FilterProvider createFilterProvider(TableViewer viewer, FilterKind kind, FindbugsPropertyPage page) {
        FilterProvider filterProvider = new FilterProvider(viewer, kind, this.propertyPage);
        filterProvider.addListener(new Listener(){

            public void handleEvent(Event event) {
                FilterFilesTab.this.refreshTables();
            }
        });
        return filterProvider;
    }

    public void setEnabled(boolean enabled) {
        this.filterExcl.setControlEnabled(enabled);
        this.filterIncl.setControlEnabled(enabled);
        this.filterExclBugs.setControlEnabled(enabled);
        super.setEnabled(enabled);
    }

    void refreshUI(UserPreferences prefs) {
        this.filterExcl.setFilters(prefs);
        this.filterExclBugs.setFilters(prefs);
        this.filterIncl.setFilters(prefs);
        this.refreshTables();
    }

    protected PathsProvider getFilterIncl() {
        return this.filterIncl;
    }

    protected PathsProvider getFilterExcl() {
        return this.filterExcl;
    }

    protected PathsProvider getFilterExclBugs() {
        return this.filterExclBugs;
    }

    public static enum FilterKind {
        INCLUDE("property.includefilter"){

            @Override
            Map<String, Boolean> selectedPaths(UserPreferences u) {
                return u.getIncludeFilterFiles();
            }

            @Override
            Map<String, Boolean> excludedPaths(UserPreferences u) {
                TreeMap<String, Boolean> excl = new TreeMap<String, Boolean>();
                excl.putAll(u.getExcludeFilterFiles());
                excl.putAll(u.getExcludeBugsFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Map<String, Boolean> files) {
                u.setIncludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE("property.excludefilter"){

            @Override
            Map<String, Boolean> selectedPaths(UserPreferences u) {
                return u.getExcludeFilterFiles();
            }

            @Override
            Map<String, Boolean> excludedPaths(UserPreferences u) {
                TreeMap<String, Boolean> excl = new TreeMap<String, Boolean>();
                excl.putAll(u.getIncludeFilterFiles());
                excl.putAll(u.getExcludeBugsFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Map<String, Boolean> files) {
                u.setExcludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE_BUGS("property.excludebugs"){

            @Override
            Map<String, Boolean> selectedPaths(UserPreferences u) {
                return u.getExcludeBugsFiles();
            }

            @Override
            Map<String, Boolean> excludedPaths(UserPreferences u) {
                TreeMap<String, Boolean> excl = new TreeMap<String, Boolean>();
                excl.putAll(u.getIncludeFilterFiles());
                excl.putAll(u.getExcludeFilterFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Map<String, Boolean> files) {
                u.setExcludeBugsFiles(files);
            }
        };

        final String propertyName;

        private FilterKind(String propertyName) {
            this.propertyName = propertyName;
        }

        abstract Map<String, Boolean> selectedPaths(UserPreferences var1);

        abstract Map<String, Boolean> excludedPaths(UserPreferences var1);

        abstract void setPaths(UserPreferences var1, Map<String, Boolean> var2);
    }

    public static class FilterProvider
    extends PathsProvider {
        private final FilterKind kind;

        protected FilterProvider(TableViewer viewer, FilterKind kind, FindbugsPropertyPage propertyPage) {
            super(viewer, propertyPage);
            this.kind = kind;
            this.setFilters(propertyPage.getCurrentUserPreferences());
        }

        List<IPathElement> getFilterFiles(UserPreferences prefs) {
            IProject project = this.propertyPage.getProject();
            ArrayList<IPathElement> newPaths = new ArrayList<IPathElement>();
            Map<String, Boolean> filterPaths = this.kind.selectedPaths(prefs);
            if (filterPaths != null) {
                for (Map.Entry<String, Boolean> entry : filterPaths.entrySet()) {
                    IPath filterPath = FindBugsWorker.getFilterPath(entry.getKey(), project);
                    PathElement element = new PathElement(filterPath, Status.OK_STATUS);
                    element.setEnabled(entry.getValue());
                    newPaths.add(element);
                }
            }
            return newPaths;
        }

        @Override
        protected void applyToPreferences() {
            super.applyToPreferences();
            this.kind.setPaths(this.propertyPage.getCurrentUserPreferences(), this.pathsToStrings());
        }

        void setFilters(UserPreferences prefs) {
            this.setFilters(this.getFilterFiles(prefs));
        }

        @Override
        protected IStatus validate() {
            SelectionValidator validator = new SelectionValidator(this.kind, this.propertyPage);
            IStatus bad = null;
            IProject project = this.propertyPage.getProject();
            for (IPathElement path : this.paths) {
                String filterPath = FindBugsWorker.toFilterPath(path.getPath(), project).toOSString();
                IStatus status = validator.validate(filterPath);
                path.setStatus(status);
                if (status.isOK()) continue;
                bad = status;
            }
            return bad;
        }

        @Override
        protected void configureDialog(FileDialog dialog) {
            dialog.setFilterExtensions(new String[]{"*.xml"});
            dialog.setText(FindbugsPlugin.getDefault().getMessage(this.kind.propertyName) + ": select xml file(s) containing filters");
        }
    }

    static final class SelectionValidator {
        private final UserPreferences prefs;
        private final Map<String, Boolean> exclFiles;

        public SelectionValidator(FilterKind kind, FindbugsPropertyPage propertyPage) {
            this.prefs = propertyPage.getCurrentUserPreferences();
            this.exclFiles = kind.excludedPaths(this.prefs);
        }

        public IStatus validate(String path) {
            if (this.exclFiles.containsKey(path)) {
                return FindbugsPlugin.createErrorStatus("Filter selected in a conflicting list", null);
            }
            return Status.OK_STATUS;
        }
    }
}

