/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginLoader;
import java.io.File;
import java.net.URI;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.Status;

public class DetectorValidator {
    @Nonnull
    public ValidationStatus validate(String path) {
        File file = new File(path);
        PluginLoader.Summary sum = null;
        try {
            sum = PluginLoader.validate(file);
        }
        catch (IllegalArgumentException e) {
            if (FindbugsPlugin.getDefault().isDebugging()) {
                e.printStackTrace();
            }
            return new ValidationStatus(4, "Invalid FindBugs plugin archive: " + e.getMessage(), sum, e);
        }
        Plugin loadedPlugin = Plugin.getByPluginId(sum.id);
        URI uri = file.toURI();
        if (loadedPlugin != null && !uri.equals(loadedPlugin.getPluginLoader().getURI()) && loadedPlugin.isGloballyEnabled()) {
            return new ValidationStatus(4, "Duplicated FindBugs plugin: " + sum.id + ", already loaded from: " + loadedPlugin.getPluginLoader().getURI(), sum, null);
        }
        return new ValidationStatus(0, Status.OK_STATUS.getMessage(), sum, null);
    }

    public static class ValidationStatus
    extends Status {
        public static final String UNKNOWN_VALUE = "?";
        private final PluginLoader.Summary sum;

        public ValidationStatus(int severity, String message, PluginLoader.Summary sum, Throwable t) {
            super(severity, "edu.umd.cs.findbugs.plugin.eclipse", message, t);
            this.sum = sum == null ? new PluginLoader.Summary(UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE) : sum;
        }

        @Nonnull
        public PluginLoader.Summary getSummary() {
            return this.sum;
        }
    }
}

