/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.view.FindBugsConsole;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Footprint;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.engine.ClassDataAnalysisEngine;
import edu.umd.cs.findbugs.classfile.impl.AnalysisCache;
import edu.umd.cs.findbugs.log.Profiler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class FindBugs2Eclipse
extends FindBugs2 {
    private static WeakHashMap<IProject, SoftReference<List<String>>> auxClassPaths = new WeakHashMap();
    private static WeakHashMap<IProject, SoftReference<Map<ClassDescriptor, Object>>> classAnalysisCache = new WeakHashMap();
    private AnalysisCache analysisCache;
    private final IProject project;
    private final boolean cacheClassData;
    private final Reporter reporter;
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IProject) {
                FindBugs2Eclipse.cleanClassClache((IProject)event.getSource());
            } else if (event.getResource() instanceof IProject) {
                FindBugs2Eclipse.cleanClassClache((IProject)event.getResource());
            } else if (event.getDelta() != null) {
                final HashSet affectedProjects = new HashSet();
                final IResourceDelta delta = event.getDelta();
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta d1) throws CoreException {
                            if (d1 == delta || d1.getFlags() == 0 || d1.getFlags() == 131072) {
                                return true;
                            }
                            IResource resource = d1.getResource();
                            if (resource instanceof IProject) {
                                affectedProjects.add((IProject)resource);
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error traversing resource delta");
                }
                for (IProject iProject : affectedProjects) {
                    FindBugs2Eclipse.cleanClassClache(iProject);
                }
            }
        }
    };

    public FindBugs2Eclipse(IProject project, boolean cacheClassData, Reporter bugReporter) {
        this.project = project;
        this.cacheClassData = cacheClassData;
        if (cacheClassData) {
            int eventMask = 18;
            ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, eventMask);
        }
        this.reporter = bugReporter;
    }

    @Override
    protected IAnalysisCache createAnalysisCache() throws IOException {
        IAnalysisCache cache = super.createAnalysisCache();
        if (cache instanceof AnalysisCache) {
            this.analysisCache = (AnalysisCache)cache;
            if (this.cacheClassData) {
                this.reuseClassCache();
            }
        }
        return cache;
    }

    @Override
    protected void clearCaches() {
        if (this.analysisCache != null) {
            this.postProcessCaches();
        }
        super.clearCaches();
    }

    @Override
    public void dispose() {
        if (this.analysisCache != null) {
            this.analysisCache.dispose();
            this.analysisCache = null;
        }
        super.dispose();
    }

    private void reuseClassCache() {
        Map<ClassDescriptor, Object> classAnalysis;
        SoftReference<Map<ClassDescriptor, Object>> wr = classAnalysisCache.get(this.project);
        Map<ClassDescriptor, Object> map = classAnalysis = wr != null ? wr.get() : null;
        if (classAnalysis != null) {
            this.analysisCache.reuseClassAnalysis(ClassData.class, classAnalysis);
        }
    }

    private void postProcessCaches() {
        IClassPath classPath = this.analysisCache.getClassPath();
        Map<ClassDescriptor, Object> classAnalysis = this.analysisCache.getClassAnalysis(ClassData.class);
        if (classAnalysis == null) {
            return;
        }
        Set<Map.Entry<ClassDescriptor, Object>> entrySet = classAnalysis.entrySet();
        AnalysisData data = new AnalysisData();
        for (Map.Entry<ClassDescriptor, Object> entry : entrySet) {
            ++data.classCount;
            if (!(entry.getValue() instanceof ClassData)) continue;
            ClassData cd = (ClassData)entry.getValue();
            data.byteSize += (long)cd.getData().length;
        }
        Set<Map.Entry<String, ICodeBaseEntry>> entrySet2 = classPath.getApplicationCodebaseEntries().entrySet();
        DescriptorFactory descriptorFactory = DescriptorFactory.instance();
        for (Map.Entry<String, ICodeBaseEntry> entry : entrySet2) {
            String className = entry.getKey();
            if (this.cacheClassData) {
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - 6);
                }
                classAnalysis.remove(descriptorFactory.getClassDescriptor(className));
            }
            data.byteSizeApp += (long)entry.getValue().getNumBytes();
        }
        if (this.cacheClassData) {
            classAnalysis = new HashMap<ClassDescriptor, Object>(classAnalysis);
            classAnalysisCache.put(this.project, new SoftReference<Map<ClassDescriptor, Object>>(classAnalysis));
        }
        this.reportExtraData(data);
    }

    private void reportExtraData(AnalysisData data) {
        SortedBugCollection bugCollection = this.reporter.getBugCollection();
        if (bugCollection == null) {
            return;
        }
        if (FindBugsConsole.getConsole() == null) {
            return;
        }
        IOConsoleOutputStream out = FindBugsConsole.getConsole().newOutputStream();
        PrintWriter pw = new PrintWriter((OutputStream)out);
        ProjectStats stats = bugCollection.getProjectStats();
        Footprint footprint = new Footprint(stats.getBaseFootprint());
        Profiler profiler = stats.getProfiler();
        Profiler.Profile profile = profiler.getProfile(ClassDataAnalysisEngine.class);
        long totalClassReadTime = TimeUnit.MILLISECONDS.convert(profile.getTotalTime(), TimeUnit.NANOSECONDS);
        long totalTime = TimeUnit.MILLISECONDS.convert(footprint.getClockTime(), TimeUnit.MILLISECONDS);
        double classReadSpeed = totalClassReadTime > 0L ? (double)data.byteSize * 1000.0 / (double)totalClassReadTime : 0.0;
        double classCountSpeed = totalTime > 0L ? (double)data.classCount * 1000.0 / (double)totalTime : 0.0;
        double classPart = totalTime > 0L ? (double)totalClassReadTime * 100.0 / (double)totalTime : 0.0;
        double appPart = data.byteSize > 0L ? (double)data.byteSizeApp * 100.0 / (double)data.byteSize : 0.0;
        double bytesPerClass = data.classCount > 0L ? (double)data.byteSize / (double)data.classCount : 0.0;
        long peakMemory = footprint.getPeakMemory() / 0x100000L;
        pw.printf("%n", new Object[0]);
        pw.printf("Total bugs            : %1$ 20d %n", stats.getTotalBugs());
        pw.printf("Peak memory (MB)      : %1$ 20d %n", peakMemory);
        pw.printf("Total classes         : %1$ 20d %n", data.classCount);
        pw.printf("Total time (msec)     : %1$ 20d %n", totalTime);
        pw.printf("Class read time (msec): %1$ 20d %n", totalClassReadTime);
        pw.printf("Class read time (%%)   : %1$ 20.0f %n", classPart);
        pw.printf("Total bytes read      : %1$ 20d %n", data.byteSize);
        pw.printf("Application bytes     : %1$ 20d %n", data.byteSizeApp);
        pw.printf("Application bytes (%%) : %1$ 20.0f %n", appPart);
        pw.printf("Avg. bytes per class  : %1$ 20.0f %n", bytesPerClass);
        pw.printf("Analysis class/sec    : %1$ 20.0f %n", classCountSpeed);
        pw.printf("Read     bytes/sec    : %1$ 20.0f %n", classReadSpeed);
        pw.printf("            MB/sec    : %1$ 20.1f %n", classReadSpeed / 1048576.0);
        pw.flush();
        pw.close();
    }

    public static void cleanClassClache(IProject project) {
        auxClassPaths.remove(project);
        classAnalysisCache.remove(project);
    }

    static void checkClassPathChanges(List<String> auxClassPath, IProject project) {
        List<String> oldAuxCp;
        SoftReference<List<String>> wr = auxClassPaths.get(project);
        List<String> list = oldAuxCp = wr != null ? wr.get() : null;
        if (oldAuxCp != null && !oldAuxCp.equals(auxClassPath)) {
            auxClassPaths.put(project, new SoftReference<ArrayList<String>>(new ArrayList<String>(auxClassPath)));
            classAnalysisCache.remove(project);
        } else if (oldAuxCp == null) {
            auxClassPaths.put(project, new SoftReference<ArrayList<String>>(new ArrayList<String>(auxClassPath)));
        }
    }

    static class AnalysisData {
        long byteSize;
        long byteSizeApp;
        long classCount;

        AnalysisData() {
        }
    }
}

