/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.actions.FindBugsAction;
import de.tobject.findbugs.builder.FindBugsWorker;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LoadXmlAction
extends FindBugsAction {
    private static final String DIALOG_SETTINGS_SECTION = "LoadXMLDialogSettings";
    private static final String LOAD_XML_PATH_KEY = "LoadXMLPathSetting";

    @Override
    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection) || this.selection.isEmpty()) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        IProject project = this.getProject(structuredSelection);
        if (project == null) {
            return;
        }
        FileDialog dialog = this.createFileDialog(project);
        boolean validFileName = false;
        do {
            String fileName;
            if ((fileName = this.openFileDialog(dialog)) == null) {
                return;
            }
            validFileName = this.validateSelectedFileName(fileName);
            if (!validFileName) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)(fileName + " is not a file or is not readable!"));
                continue;
            }
            this.getDialogSettings().put(LOAD_XML_PATH_KEY, fileName);
            this.work(project, fileName);
        } while (!validFileName);
    }

    protected String openFileDialog(FileDialog dialog) {
        return dialog.open();
    }

    private boolean validateSelectedFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        return file.isFile() && file.canRead();
    }

    private FileDialog createFileDialog(IProject project) {
        FileDialog fileDialog = new FileDialog(FindbugsPlugin.getShell(), 69632);
        fileDialog.setText("Select bug result xml for project: " + project.getName());
        String initialFileName = this.getDialogSettings().get(LOAD_XML_PATH_KEY);
        if (initialFileName != null && initialFileName.length() > 0) {
            File initialFile = new File(initialFileName);
            if (initialFile.exists()) {
                fileDialog.setFileName(initialFile.getName());
            }
            fileDialog.setFilterPath(initialFile.getParent());
        }
        return fileDialog;
    }

    @Override
    protected String getDialogSettingsId() {
        return DIALOG_SETTINGS_SECTION;
    }

    private void work(final IProject project, final String fileName) {
        FindBugsJob runFindBugs = new FindBugsJob("Loading XML data from " + fileName + "...", (IResource)project){

            @Override
            protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
                FindBugsWorker worker = new FindBugsWorker(project, monitor);
                worker.loadXml(fileName);
            }
        };
        runFindBugs.setRule((ISchedulingRule)project);
        runFindBugs.scheduleInteractive();
    }
}

