/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.util.ProjectUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;

public class FindbugsSaveParticipant
implements ISaveParticipant {
    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) {
        switch (context.getKind()) {
            case 1: {
                this.fullSave();
                break;
            }
            case 3: {
                this.saveBugCollection(context.getProject());
                break;
            }
        }
    }

    private void fullSave() {
        IProject[] projectList;
        for (IProject project : projectList = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!project.isAccessible() || !ProjectUtilities.isJavaProject(project)) continue;
            this.saveBugCollection(project);
        }
    }

    private void saveBugCollection(IProject project) {
        if (project.isAccessible()) {
            try {
                FindbugsPlugin.saveCurrentBugCollection(project, null);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                FindbugsPlugin.getDefault().logException(e, "Could not save bug collection for project " + project.getName());
            }
        }
    }
}

