/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class FindBugsJob
extends Job {
    private static final Semaphore analysisSem = new Semaphore(MutexSchedulingRule.MAX_JOBS, true);
    private static final boolean DEBUG = false;
    private final IResource resource;

    public static void cancelSimilarJobs(FindBugsJob job) {
        Job[] jobs;
        if (job.getResource() == null) {
            return;
        }
        for (Job job2 : jobs = Job.getJobManager().find(FindbugsPlugin.class)) {
            if (!(job2 instanceof FindBugsJob) || !job.getResource().equals((Object)((FindBugsJob)job2).getResource()) || job2.getState() == 4) continue;
            job2.cancel();
        }
    }

    public FindBugsJob(String name, IResource resource) {
        super(name);
        this.resource = resource;
        this.setRule(new MutexSchedulingRule(resource));
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean belongsTo(Object family) {
        return FindbugsPlugin.class == family;
    }

    public void scheduleInteractive() {
        this.setUser(true);
        this.setPriority(10);
        if (this.supportsMulticore() && analysisSem.availablePermits() == 0 && Job.getJobManager().find(FindbugsPlugin.class).length == 0) {
            analysisSem.release(MutexSchedulingRule.MAX_JOBS);
        }
        this.schedule();
    }

    public void scheduleAsSystem() {
        this.setUser(false);
        this.setPriority(40);
        this.schedule();
    }

    protected String createErrorMessage() {
        return this.getName() + " failed";
    }

    protected abstract void runWithProgress(IProgressMonitor var1) throws CoreException;

    protected boolean supportsMulticore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        boolean acquired = false;
        try {
            if (this.supportsMulticore()) {
                analysisSem.acquire();
                acquired = true;
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
            this.runWithProgress(monitor);
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (CoreException ex) {
            IStatus iStatus = ex.getStatus();
            return iStatus;
        }
        catch (InterruptedException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            if (acquired) {
                analysisSem.release();
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    static {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getProgressService().registerIconForFamily(FindbugsPlugin.getDefault().getImageDescriptor("runFindbugs.png"), FindbugsPlugin.class);
            }
        });
    }
}

