/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DetectorsExtensionHelper {
    private static final String DEFAULT_USE_PLUGIN_JAR = ".";
    private static final String EXTENSION_POINT_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsPlugins";
    private static final String LIBRARY_PATH = "libraryPath";
    private static final String PLUGIN_ID = "fbPluginId";
    private static SortedMap<String, String> contributedDetectors;

    public static synchronized SortedMap<String, String> getContributedDetectors() {
        IExtension[] extensions;
        if (contributedDetectors != null) {
            return new TreeMap<String, String>(contributedDetectors);
        }
        TreeMap<String, String> set = new TreeMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            return set;
        }
        for (IExtension extension : extensions = point.getExtensions()) {
            IConfigurationElement[] elements;
            for (IConfigurationElement configElt : elements = extension.getConfigurationElements()) {
                DetectorsExtensionHelper.addContribution(set, configElt);
            }
        }
        contributedDetectors = set;
        return new TreeMap<String, String>(contributedDetectors);
    }

    private static void addContribution(TreeMap<String, String> set, IConfigurationElement configElt) {
        IContributor contributor = null;
        try {
            contributor = configElt.getContributor();
            if (contributor == null) {
                throw new IllegalArgumentException("Null contributor");
            }
            String pluginId = configElt.getAttribute(PLUGIN_ID);
            if (pluginId == null) {
                throw new IllegalArgumentException("Missing 'fbPluginId'");
            }
            String libPathAsString = configElt.getAttribute(LIBRARY_PATH);
            if (libPathAsString == null) {
                throw new IllegalArgumentException("Missing 'libraryPath'");
            }
            if ((libPathAsString = DetectorsExtensionHelper.resolveRelativePath(contributor, libPathAsString)) == null) {
                throw new IllegalArgumentException("Failed to resolve library path for: " + pluginId);
            }
            if (set.containsKey(pluginId)) {
                throw new IllegalArgumentException("Duplicated '" + pluginId + "' contribution.");
            }
            set.put(pluginId, libPathAsString);
        }
        catch (Throwable e) {
            String cName = contributor != null ? contributor.getName() : "unknown contributor";
            String message = "Failed to read contribution for 'edu.umd.cs.findbugs.plugin.eclipse.findbugsPlugins' extension point from " + cName;
            FindbugsPlugin.getDefault().logException(e, message);
        }
    }

    @CheckForNull
    private static String resolveRelativePath(IContributor contributor, String libPathAsString) {
        File bundleFile;
        String bundleName = contributor.getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        try {
            bundleFile = FileLocator.getBundleFile((Bundle)bundle);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to resolve detector library for " + bundle.getSymbolicName());
            return null;
        }
        boolean runningInDebugger = Boolean.getBoolean("eclipse.pde.launch");
        if (!DEFAULT_USE_PLUGIN_JAR.equals(libPathAsString)) {
            return new Path(bundleFile.getAbsolutePath()).append(libPathAsString).toOSString();
        }
        if (!bundleFile.isDirectory()) {
            return bundleFile.getAbsolutePath();
        }
        if (runningInDebugger) {
            return DetectorsExtensionHelper.resolvePluginClassesDir(bundleName, bundleFile);
        }
        IllegalArgumentException e = new IllegalArgumentException("Failed to resolve detector library for " + bundle.getSymbolicName());
        String message = "Failed to resolve detector library. '" + bundleFile + "' is a directory and can't be used as FindBugs detector package." + " Please specify '" + LIBRARY_PATH + "' argument as a relative path to the detectors jar file.";
        FindbugsPlugin.getDefault().logException(e, message);
        return null;
    }

    @CheckForNull
    private static String resolvePluginClassesDir(String bundleName, File sourceDir) {
        if (sourceDir.listFiles() == null) {
            FindbugsPlugin.getDefault().logException(new IllegalStateException("No files in the bundle!"), "Failed to create temporary detector package for bundle " + sourceDir);
            return null;
        }
        String outputDir = DetectorsExtensionHelper.getBuildDirectory(bundleName, sourceDir);
        if (outputDir.length() == 0) {
            FindbugsPlugin.getDefault().logException(new IllegalStateException("No output directory in build.properties"), "No output directory in build.properties " + sourceDir);
            return null;
        }
        File classDir = new File(sourceDir, outputDir);
        if (classDir.listFiles() == null) {
            FindbugsPlugin.getDefault().logException(new IllegalStateException("No files in the bundle output dir!"), "Failed to create temporary detector package for bundle " + sourceDir);
            return null;
        }
        File etcDir = new File(sourceDir, "etc");
        if (etcDir.listFiles() == null) {
            FindbugsPlugin.getDefault().logException(new IllegalStateException("No files in the bundle etc dir!"), "Failed to create temporary detector package for bundle " + sourceDir);
            return null;
        }
        return classDir.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static String getBuildDirectory(String bundleName, File sourceDir) {
        Properties props = new Properties();
        File buildProps = new File(sourceDir, "build.properties");
        if (buildProps.isFile()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(buildProps);
                props.load(inStream);
            }
            catch (IOException e) {
                try {
                    FindbugsPlugin.getDefault().logException(e, "Failed to read build.properties for bundle " + bundleName);
                }
                catch (Throwable throwable) {
                    IO.closeQuietly(inStream);
                    throw throwable;
                }
                IO.closeQuietly(inStream);
            }
            IO.closeQuietly(inStream);
        }
        return props.getProperty("output..", "");
    }
}

