/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class EnhancedProperties
implements Serializable {
    private static final long serialVersionUID = 4105281128024379352L;
    private final HashMap<String, Serializable> map;

    public EnhancedProperties() {
        this.map = new HashMap();
    }

    public EnhancedProperties(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public EnhancedProperties(EnhancedProperties props) {
        this();
        this.addAll(props);
    }

    public void setProperty(String key, Serializable value) {
        this.map.put(key, value);
    }

    public Serializable getProperty(String key) {
        return this.map.get(key);
    }

    public Serializable getProperty(String key, Serializable defaultValue) {
        Serializable value = this.map.get(key);
        return value == null ? defaultValue : value;
    }

    public Set<Map.Entry<String, Serializable>> entrySet() {
        return this.map.entrySet();
    }

    public void addAll(EnhancedProperties otherProps) {
        this.map.putAll(otherProps.map);
    }

    public void addAll(Map<String, Serializable> otherMap) {
        this.map.putAll(otherMap);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<String> differences(EnhancedProperties otherProps) {
        LinkedList<String> differences = new LinkedList<String>();
        for (Map.Entry<String, Serializable> entry : this.map.entrySet()) {
            Serializable value = otherProps.getProperty(entry.getKey());
            if (value == null) {
                if (entry.getValue() == null) continue;
                differences.add(entry.getKey());
                continue;
            }
            if (value.equals(entry.getValue())) continue;
            differences.add(entry.getKey());
        }
        this.map.clear();
        this.map.putAll(otherProps.map);
        return differences;
    }

    public Map<String, Serializable> asMap() {
        return this.map;
    }
}

